<?php
/**********************************************************
* Source Copyright 2014 Author                            *
* Unauthorized reproduction is not allowed                *
* Author: JPK Software Solutions Pvt. Ltd.                *
* Email: sales@visionhelpdesk.com                         *
* Owner: www.visionhelpdesk.com                           *
**********************************************************/
if(!defined('_VIS_')) die('Error: Call from undefined function');
class cmdb {
    var $error;

	//************CMDB CONTRACT SECTION STARTS************************************
	/*VIEW CONTRACT LIST*/
	function contract($operation){
		global $vis_language;
        $page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
        $sort_by=(isset($operation['vis_sort_by']))?$operation['vis_sort_by']:'';
        $operation['view_title']=$vis_language['TXTCONTRACT'];
        $filter='';
		if(isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)
        {
			$data= isset($operation['vis_action']) && $operation['vis_action']!='' ? parse_form_array($operation['vis_action']) : $operation;             
		    if($data['vis_name']!='') $filter=" ".VIS_TABLE_PREFIX."itil_cmdb_contract.name like '%".$data['vis_name']."%' and ";
		    if($data['vis_contract_type']!='') $filter .=" type=".$data['vis_contract_type']." and ";
		    if($data['vis_vendor']!='') $filter .=" vendor=".$data['vis_vendor']." and ";
		    if($data['vis_end_date']!=''){ 
			$end=strtotime($data['vis_end_date'])-VIS_TIMEZONE;
			$filter .=" end_date = ".$end." and ";
			}
			$filter=substr($filter, 0, -4);
		}
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$staff=new class_staff($database);
        
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'cmdb.php');
        $cmdb_object=new class_cmdb($database);
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $setting_object=new class_setting($database);
        
        list($view_info, $view_details)=$staff->get_ticket_view(VIS_STAFF_ID, VIS_LOCATION_AREA);
        $limit=($page*$view_info['page_count']).','.$view_info['page_count'];
        $contract_details=$cmdb_object->get_contract($filter, $limit, $page, $sort_by, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$contract_count=$cmdb_object->get_contract($filter, '', $page, $sort_by, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $contract_list_count =($contract_count!=-1)? count($contract_count):0;
        $view_info['page_count']=($contract_count==-1)?0:ceil($contract_list_count/$view_info['page_count']);
		$view_info['view_count']=count($contract_count);
       
        list($contract_type_info, $contract_type_details)=$setting_object->get_contract_type('', '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        list($vendor_info, $vendor_details)=$setting_object->get_vendor('', '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $database->database_disconnect();
        if(VIS_LOCATION_AREA == 0) {
			if($contract_details!=-1) echo get_xml($contract_details, 'contract');
			else echo $vis_language['MSGDATANOTFND'];
		}
        if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){
			ob_start();
			include(VIS_PATH_TEMPLATE.'cmdb_contract_list.php');
			$contract_list = ob_get_clean();
			ob_end_flush();			
			$select='';
			$select .= "<div class=\"pull-right\">";
			$select .= "<select name=\"pageing\" id=\"paging\" class=\"form-control input-sm selectpicker pull-right paging v-middle\"  onChange=\"javascript:vis_apply_filter(this.value);\">";					  
			for($i=0;$i<$view_info['page_count'];$i++)
				$select.='<option value="'.$i.'" '.(($page==$i)?'selected="selected"':'').'>'.($i+1).'</option>';
			$select .= "</select><div class=\"text-muted pull-right label_page\">".$vis_language['TXTPAGE'].":</div>";
			
			echo json_encode( array('total_cnt'=>$contract_list_count, 'paging' => $select, 'list'=> $contract_list));
		}else 
			include(VIS_PATH_TEMPLATE.'cmdb_contract.php');
        return true;
    }
    /*VIEW NEW CONTRACT FORM*/
    function new_cmdb_contract($operation){
		global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'cmdb.php');
        $cmdb_object=new class_cmdb($database);
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $setting_object=new class_setting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
        $ticket_object=new class_ticket($database);
		include_once(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.'ticket.php');
		$ticket_module=new ticket($database);
        $ci_product_details=$ticket_module->get_properties('get_product', '');
        $contract_type_details=$ticket_module->get_properties('get_contracttype', '');
        $license_type_details=$ticket_module->get_properties('get_licensetype', '');	
		
		$filter=(VIS_TABLE_PREFIX.'department.is_enabled=1 and '.VIS_TABLE_PREFIX.'domain.is_enabled=1');
        $departments=$ticket_object->get_department($filter, VIS_STAFF_ID, VIS_LOCATION_AREA, VIS_TABLE_PREFIX.'domain.domain_id');
        
		$filter =  VIS_TABLE_PREFIX.'domain.domain_id='.$departments[0]['domain_id'];
		$domain_details=$ticket_object->get_domain($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
		include(VIS_PATH_TEMPLATE.'cmdb_contract_new.php');
        return true;
	}
	/*CHANGE VENDOR AS PER PRODUCT*/
	function change_vendor($operation){
		global $vis_language;
		$database=new class_database();
		
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $setting_object=new class_setting($database);
        $filter = VIS_TABLE_PREFIX.'itil_ci_product.product_id='.$operation['vis_product_id'].'';
        $vendor_details=$setting_object->get_ciproduct_list($filter,$data,VIS_STAFF_ID, VIS_LOCATION_AREA,'');
        $search = (count($vendor_details)>10)? 'data-live-search="true"' : '';
		$select='';
		$select .= "<select name=\"vis_vendor\" id=\"vis_vendor\" class=\"form-control input-sm  v-middle selectpicker\" ".$search." >";
		$select .= "<option value=''>".$vis_language['TXTSELECT']."</option>";
		
		if($vendor_details!=-1){
			$selected='';
			for($i=0;$i<count($vendor_details);$i++){
				if(isset($operation['vis_vendor_id']) && $operation['vis_vendor_id']!=''){
					$selected = ($operation['vis_vendor_id']==$vendor_details[$i]['vendor_id'])?'selected="selected"':'';
				}
				$select.='<option value="'.$vendor_details[$i]['vendor_id'].'" '.$selected.'>'.$vendor_details[$i]['vendor_name'].'</option>';
			}
		}
		$select .= "</select>";
		$select .='<script>$(".selectpicker").selectpicker();</script>';
		echo json_encode( array('list' => $select));
        return true;
	}
	/*ADD NEW CONTRACT*/
	function add_new_contract($operation){
		global $vis_language;
        $data=parse_form_array($operation['vis_action']);
		
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'cmdb.php');
        $cmdb_object=new class_cmdb($database);
        if(trim($data['vis_department'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQUIREDFIELDDEPARTMENT'].'"); </script>';
            return false;
        }
		if(trim($data['vis_name'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFLDCNTRNAME'].'"); </script>';
            return false;
        }
        if(trim($data['vis_contract_type'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQCONTRACTTYPE'].'"); </script>';
            return false;
        }
        if(trim($data['vis_product'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFLDPRODUCT'].'"); </script>';
            return false;
        }
        if(trim($data['vis_vendor'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQVENDOR'].'"); </script>';
            return false;
        }
        if(trim($data['vis_license_count'])=='' || !is_numeric($data['vis_license_count'])) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQLICCNT'].'"); </script>';
            return false;
        }        
        if(trim($data['vis_aprover'])=='' || !is_numeric($data['vis_aprover'])) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQUIREDFIELDAPPROVER'].'"); </script>';
            return false;
        }
		if(trim($data['vis_cost'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFIELDCOST'].'"); </script>';
            return false;
        }
		if(!is_numeric($data['vis_cost'])){
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGCOSTNUM'].'"); </script>';
	         return false;
        }
        if(trim($data['vis_start_date'])=='' || trim($data['vis_end_date'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQDATE'].'"); </script>';
            return false;
        }else{
			$start_date=strtotime($data['vis_start_date']);
			$end_date=strtotime($data['vis_end_date']);
			if($start_date >= $end_date){
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALIDENDDATE'].'"); </script>';
				return false;
			}
			
		}
        if(isset($data['vis_notify_expiry']) && $data['vis_notify_expiry']==1){
			if(trim($data['vis_notify_before'])=='' || !is_numeric($data['vis_notify_before'])) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQNOTIEXP'].'"); </script>';
				return false;
			}
		   if(isset($data['vis_notify_to']) || trim($data['vis_notify_to'])!='')
		   {
			list($message, $flag) = check_email_validation($data['vis_notify_to']);
			if(!$flag) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$message.'"); </script>';
				return false;
			} 
		  }			
		}else{
			$data['vis_notify_before']=$data['vis_notify_to']='';
		}
		if (defined('VIS_HTML_EDITOR') && VIS_HTML_EDITOR != 1) 
        $data['vis_description'] = str_replace(array("\r\n","\r","\n"),"<br>",$data['vis_description']);
		list($data['domain_id'], $data['department_id'])=explode(':', $data['vis_department']);
		$data['vis_contract_num']=$cmdb_object->get_itil_hash($data['domain_id'], '10', 'vis_itil_contracts_prefix', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$data['vis_status']=(isset($operation['vis_for_aproval']) && $operation['vis_for_aproval']==1)?1:0;
		$ret=$cmdb_object->add_contract($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($data['vis_status']==1){
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
			$staff_object=new class_staff($database);
			$staff=$staff_object->get_staff('staff_id='.$data['vis_aprover'], VIS_STAFF_ID, VIS_LOCATION_AREA);
			$data['staff']=$staff[0];
			$data['template_id']=18;
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'mail.php');
            $mobject=new class_mail($database);
            $data['vis_module']='cmdb';
			$data['contract_id']=$ret['inserted_id'];
            $rert=$mobject->email_notify($data, 'contract_aproval_mail', VIS_STAFF_ID, VIS_LOCATION_AREA);
		}
		if($ret['success']!=1) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else{
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
			$setting_object=new class_setting($database);
			$activity_log=$setting_object->add_staff_activity_log("Added new contract ".$data['vis_name'], VIS_STAFF_ID, 5, VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");$("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTCONTRACT'].'",{"vis_module":"'.$operation['vis_module'].'", "vis_operation":"contract"});</script>';
		}
		$database->database_disconnect();
        return true;
	}
	
	/*SELECTED APROVER BY DEPARTMENT*/
	function change_aprover($operation){
		global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$staff_object=new class_staff($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$setting_object=new class_setting($database);		
		if(strpos($operation['department_id'],':')) 
		{
			list($operation['domain_id'], $operation['department_id'])=explode(':', $operation['department_id']);
		}
		else
		{
			$query3=' select domain_id from '.VIS_TABLE_PREFIX.'department where department_id='.$operation['department_id'];
			$domain_id=$database->query_exec($query3);
			$domain_id=$database->fetch_result_array($domain_id);
			$operation['domain_id']=$domain_id[0]['domain_id'];
		}
		$staff_list = $staff_object->get_staff('is_enabled=1',VIS_STAFF_ID, VIS_LOCATION_AREA, $operation['department_id']);
		$filter=''.VIS_TABLE_PREFIX.'domain.is_enabled=1 and '.VIS_TABLE_PREFIX.'domain.domain_id='.$operation['domain_id'];
		list($dpinf, $domain)=$setting_object->get_domain($filter, '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$search = (count($staff_list)>10)? 'data-live-search="true"' : '';
		$select='';
		$select .= "<select name=\"vis_aprover\" id=\"vis_aprover\" class=\"form-control input-sm  v-middle selectpicker\" ".$search." >";
		$select .= "<option value=''>".$vis_language['TXTSELECT']."</option>";
		
		if($staff_list!=-1){
			$selected='';
			for($i=0;$i<count($staff_list);$i++){
				if(isset($operation['approver_id']) && $operation['approver_id']!='0'){
					$selected = ($operation['approver_id']==$staff_list[$i]['staff_id'])?'selected="selected"':'';
				}
				$select.='<option value="'.$staff_list[$i]['staff_id'].'" '.$selected.'>'.$staff_list[$i]['first_name'].' '.$staff_list[$i]['last_name'].'</option>';
			}
		}
		$select .= "</select>";
		$select .='<script>$(".selectpicker").selectpicker();</script>';
		$cost_currency = $vis_language['TXTCOST']." (".$domain[0]['currency'].")";
		echo json_encode( array('list' => $select, 'cost'=>$cost_currency));
		
		return true;
	}
	/*VIEW CONTRACT DETAILS*/
	function contract_details($operation){ 
		global $vis_language;
		$spliter=(strstr($operation['vis_action'], '/'))?'/':',';
		$action=explode($spliter, $operation['vis_action']);
		if(VIS_LOCATION_AREA == 0) $action[4]=(isset($operation['vis_contract_id']) && $operation['vis_contract_id']!='')?$operation['vis_contract_id']:'';
		if(isset($action[4]) && $action[4]!='' && is_numeric($action[4])) {
			$database=new class_database();
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'cmdb.php');
			$cmdb_object=new class_cmdb($database);
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
			$setting_object=new class_setting($database);
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
			$staff_object=new class_staff($database);
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
			$ticket_object=new class_ticket($database);
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
			$problem_object=new class_problem($database);
			$filter='contract_id='.$action[4];
			$contract_details=$cmdb_object->get_contract($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
			$contract_details=$contract_details[0];
			
			//$filter=(VIS_TABLE_PREFIX.'department.is_enabled=1 and '.VIS_TABLE_PREFIX.'domain.is_enabled=1');
			//$departments=$ticket_object->get_department($filter, VIS_STAFF_ID, VIS_LOCATION_AREA, VIS_TABLE_PREFIX.'domain.domain_id');
			list($dpinf, $domain)=$setting_object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1 and '.VIS_TABLE_PREFIX.'domain.domain_id='.VIS_DOMAIN, '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
			
			$filter=' ('.VIS_TABLE_PREFIX.'itil_ci_product.department_access=0 or find_in_set('.$contract_details['department_id'].','.VIS_TABLE_PREFIX.'itil_ci_product.department_access)) ';
			list($ci_product_info, $ci_product_details)=$setting_object->get_ci_product($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
			$filter=' ('.VIS_TABLE_PREFIX.'itil_contract_type.department_access=0 or find_in_set('.$contract_details['department_id'].','.VIS_TABLE_PREFIX.'itil_contract_type.department_access)) ';
			list($contract_type_info, $contract_type_details)=$setting_object->get_contract_type($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
			$filter=' ('.VIS_TABLE_PREFIX.'itil_license_type.department_access=0 or find_in_set('.$contract_details['department_id'].','.VIS_TABLE_PREFIX.'itil_license_type.department_access)) ';
			list($license_type_info, $license_type_details)=$setting_object->get_license_type($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
			$staff_list = $staff_object->get_staff('is_enabled=1',VIS_STAFF_ID, VIS_LOCATION_AREA);
			
			if (defined('VIS_HTML_EDITOR') && VIS_HTML_EDITOR != 1) {  	
				$contract_details['description'] = get_plain_text($contract_details['description']);	
		    }
			$filter = ' vendor_id='.$contract_details['vendor'].'';
			list($cnt, $vendor_details)=$setting_object->get_vendor($filter,'','','',VIS_STAFF_ID, VIS_LOCATION_AREA);
			if($contract_details!=''){
			$filter = " attach_type=13 AND parent_id=".$action[4];
			list($total_ci, $attached_ci)=$problem_object->get_attach_ci($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
				if($attached_ci!=-1){
					$ci_all='';
					foreach($attached_ci as $rows){	$ci_all .= $rows['assets_id'].','; }
					$contract_details['attach_ci']=$ci_all;
				}
			}
			if($contract_details['attach_file']!=''){
				$files= explode(',', $contract_details['attach_file']);
				for($i=0;$i<count($files)-1;$i++){
					$contract_details['files'][]=$cmdb_object->get_uploaded_file('attachment_id='.$files[$i], '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
				}
			}
			if(VIS_LOCATION_AREA == 0) {
				if($contract_details!='') echo get_xml($contract_details, 'contract_details');
				else echo $vis_language['MSGDATANOTFND'];
			}
			$btn_class = '';
			
			if($contract_details['status']==0){
				$filter=(VIS_TABLE_PREFIX.'department.is_enabled=1 and '.VIS_TABLE_PREFIX.'domain.is_enabled=1');
				$departments=$ticket_object->get_department($filter, VIS_STAFF_ID, VIS_LOCATION_AREA, VIS_TABLE_PREFIX.'domain.domain_id');
				$btn_class .= "<button type=\"button\" class=\"btn btn-primary\" onclick=\"$(this).visExecution('submit_form',{'vis_module':'cmdb', 'vis_operation':'edit_contract', 'vis_form':'vis_update_contract_form'})\">".$vis_language['TXTUPDATE']."</button>  <button type=\"button\" class=\"btn btn-primary\" onclick=\"$(this).visExecution('submit_form',{'vis_module':'cmdb', 'vis_operation':'edit_contract', 'vis_form':'vis_update_contract_form', 'vis_for_aproval':'1'})\">".$vis_language['TXTSUBMITAPROVAL']."</button>";
				include(VIS_PATH_TEMPLATE.'cmdb_contract_update.php');
			}
			else {
				if($contract_details['status']==1){
					if($contract_details['approver']==VIS_STAFF_ID){
						$btn_class .= "<button type=\"button\" class=\"btn btn-primary\" onclick=\"change_contract_status('".$contract_details['contract_id']."',2)\">".$vis_language['TXTITILAPROVE']."</button> <button type=\"button\" class=\"btn btn-primary\" onclick=\"change_contract_status('".$contract_details['contract_id']."',3)\">".$vis_language['TXTITILREJECT']."</button>";
					}
				}
				else if($contract_details['status']==2){
					if($contract_details['approver']==VIS_STAFF_ID){
						$btn_class .= "<button type=\"button\" class=\"btn btn-primary\" onclick=\"change_contract_status('".$contract_details['contract_id']."',4)\">".$vis_language['TXTITILTERMINATE']."</button>";
					}
				}
				list($dpinf, $domain)=$setting_object->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1 and '.VIS_TABLE_PREFIX.'department.department_id='.$contract_details['department_id'], '', 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
				
				include(VIS_PATH_TEMPLATE.'cmdb_contract_details.php');
				return true;
			}
		}
	}
	/*UPDATE CONTRACT STATUS*/
	function change_contract_status($operation){
		global $vis_language;
		$database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'cmdb.php');
        $cmdb_object=new class_cmdb($database);
		if(isset($operation['contract_id']) && $operation['contract_id']!='' && $operation['status']>5) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
		$filter='contract_id='.$operation['contract_id'];
		$contract_details=$cmdb_object->get_contract($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $ret=$cmdb_object->update_contract_status($operation, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else{
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
			$setting_object=new class_setting($database);
			$activity_log=$setting_object->add_staff_activity_log("Change ".$contract_details[0]['name']." contract status", VIS_STAFF_ID, 5, VIS_LOCATION_AREA);
			if($operation['status']==2){
				echo $btn_class .= "<button type='button' class='btn btn-primary' onclick='change_contract_status(\"".$operation['contract_id']."\", 4)'>".$vis_language['TXTITILTERMINATE']."</button>";
			}else if($operation['status']==3){
				echo $btn_class .= "";
			}
			//echo "<script> $('#btn_class').html(\"".$btn_class."\");";
			
		}
		$database->database_disconnect();
        return true;
	}
	/* UPDATE CONTRACT DETAILS*/
	function edit_contract($operation){
		global $vis_language;
        $data=parse_form_array($operation['vis_action']);
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'cmdb.php');
        $cmdb_object=new class_cmdb($database);
        
		if(trim($data['vis_department'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQUIREDFIELDDEPARTMENT'].'"); </script>';
            return false;
        }
        if(trim($data['vis_name'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFLDCNTRNAME'].'"); </script>';
            return false;
        }
        if(trim($data['vis_contract_type'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQCONTRACTTYPE'].'"); </script>';
            return false;
        }
        if(trim($data['vis_product'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFLDPRODUCT'].'"); </script>';
            return false;
        }
        if(trim($data['vis_vendor'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQVENDOR'].'"); </script>';
            return false;
        }
        if(trim($data['vis_license_count'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQLICCNT'].'"); </script>';
            return false;
        }
        if(trim($data['vis_license_count'])=='' || !is_numeric($data['vis_license_count'])) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQLICCNT'].'"); </script>';
            return false;
        }		
		if(trim($data['vis_aprover'])=='' || !is_numeric($data['vis_aprover'])) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQUIREDFIELDAPPROVER'].'"); </script>';
            return false;
        }
        if(trim($data['vis_cost'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFIELDCOST'].'"); </script>';
            return false;
        }
		if(!is_numeric($data['vis_cost'])){
             echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGCOSTNUM'].'"); </script>';
	         return false;
        }
        if(trim($data['vis_start_date'])=='' || trim($data['vis_end_date'])=='') {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQDATE'].'"); </script>';
            return false;
        }else{
			$start_date=strtotime($data['vis_start_date']);
			$end_date=strtotime($data['vis_end_date']);
			if($start_date >= $end_date){
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALIDENDDATE'].'"); </script>';
				return false;
			}
			
		}
        if(isset($data['vis_notify_expiry']) && $data['vis_notify_expiry']==1){
			if(trim($data['vis_notify_before'])=='' || !is_numeric($data['vis_notify_before'])) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQNOTIEXP'].'"); </script>';
				return false;
			}
			if(isset($data['vis_notify_to']) || trim($data['vis_notify_to'])!='')
		   {
			list($message, $flag) = check_email_validation($data['vis_notify_to']);
			if(!$flag) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$message.'"); </script>';
				return false;
			} 
		  }	
		}else{
			$data['vis_notify_before']=$data['vis_notify_to']='';
		}
		if(defined('VIS_HTML_EDITOR') && VIS_HTML_EDITOR==0) 
		$data['vis_description'] = str_replace(array("\r\n","\r","\n"),"<br>",$data['vis_description']);
		$data['department_id']= $data['vis_department'];
		$data['vis_status']=(isset($operation['vis_for_aproval']) && $operation['vis_for_aproval']==1)?1:0;
		$ret=$cmdb_object->update_contract($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
        if($data['vis_status']==1){
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
			$staff_object=new class_staff($database);
			$staff=$staff_object->get_staff('staff_id='.$data['vis_aprover'], VIS_STAFF_ID, VIS_LOCATION_AREA);
			$data['staff']=$staff[0];
			$data['template_id']=18;
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'mail.php');
            $mobject=new class_mail($database);
            $data['vis_module']='cmdb';
			$data['contract_id']=$data['vis_contract_id'];
            $rert=$mobject->email_notify($data, 'contract_aproval_mail', VIS_STAFF_ID, VIS_LOCATION_AREA);
		}
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }else{
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
			$setting_object=new class_setting($database);
			$activity_log=$setting_object->add_staff_activity_log($data['vis_name']." contract updated", VIS_STAFF_ID, 5, VIS_LOCATION_AREA);
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");$("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTCONTRACT'].'",{"vis_module":"'.$operation['vis_module'].'", "vis_operation":"contract"});</script>';
		 }
        $database->database_disconnect();
        return true;
	}
	/*CONFIRMATION MODEL FORM*/
	function get_contract_delete($operation) {
        global $vis_language;
        $message_info['vis_form_title']=$vis_language['TXTDELCONTRACT'];
		$message_info['vis_message']=$vis_language['MSGSURE'];
        $message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'".$operation['vis_module']."', 'vis_operation':'delete_contract', 'vis_contract_id':".$operation['vis_contract_id']."})";
        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
    }
    /*DELETE CONTRACT*/
    function delete_contract($operation){
		global $vis_language;
        $flag=true;
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'cmdb.php');
        $cmdb_object=new class_cmdb($database);
        $setting_object=new class_setting($database);

		$contract=$cmdb_object->get_contract('contract_id='.$operation['vis_contract_id'], '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($contract!=-1) 
            $ret = $cmdb_object->delete_contract($operation['vis_contract_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
               
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$setting_object->add_staff_activity_log("Removed  ".$contract[0]['name']." contract", VIS_STAFF_ID, 5, VIS_LOCATION_AREA);
			echo '<script>$("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_module'].'", "vis_operation":"contract"}); </script>';
		}
        $database->database_disconnect();
        return true;
	}
	/*ATTACH CI MODEL FORM*/
	function attach_ci($operation){
		global $vis_language;
		$database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$setting_object=new class_setting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'cmdb.php');
        $cmdb_object=new class_cmdb($database);
		
		if($operation['vis_item_details']){
			$data=parse_form_array($operation['vis_action']);
			$flag=0;$ci_attach_id=$data['vis_attach_prev_ci'];$count=0;
			
			for($i=0;$i<$data['total_itemrecord'];$i++){
				
				if(isset($data['vis_attach_id_'.$i])){
					$flag=1;
					$filter = ' assets_id='.$data['vis_attach_id_'.$i];
					$assets_details=$cmdb_object->get_assets($filter,'', '','',VIS_STAFF_ID, VIS_LOCATION_AREA);
					$array_data[$count]['id']=$assets_details[0]['assets_id'];
					$array_data[$count]['title']=$assets_details[0]['name'];
					$ci_attach_id .=$array_data[$count]['id'].",";
					$count++;
				}
			}
			if($flag==1){
				$final_data ='';
				for($j=0;$j<count($array_data);$j++){
					$final_data .='<div class="btn-group wrapper-xxs">';
					$final_data .='<span class="btn btn-xs alert-info">'.$array_data[$j]['title'].'</span>';
					$final_data .='<button onclick="vis_remove_ci_attachment('.$array_data[$j]['id'].');" data-dismiss="alert" type="button" class="btn btn-xs alert-info"><i class="vh vh-cross"></i></button></div>';
				}
				if($operation['vis_static_area']=='vis_add_cito_ticket'){
					$attach_ci_btn='<a href="javascript:void(0);" data-toggle="ajaxModal" data-modal-arguments="vis_module=cmdb&vis_operation=attach_ci&vis_department='.$operation['vis_department'].'&vis_static_area=vis_add_cito_ticket&attached_ci_ids='.$ci_attach_id.'" class="link text-primary v-middle">'.$vis_language['TXTATTACHCI'].'</a>';
				}else{
					$attach_ci_btn='<a href="javascript:void(0);" data-toggle="ajaxModal" data-modal-arguments="vis_module=cmdb&vis_operation=attach_ci&vis_department='.$operation['vis_department'].'&vis_static_area=vis_add_ciproduct_dialog&attached_ci_ids='.$ci_attach_id.'" class="btn btn-rounded btn-default btn-sm dropdown-toggle"><i class="vh vh-plus" style="font-size:10px;"></i>&nbsp;'.$vis_language['TXTSELECTCI'].'</a>';
				}
				echo "<script> $('#vis_select_cit_btn').html('".$attach_ci_btn."');$('.modal').modal('toggle');";
				echo "$('.attach_ci_div').css('display', 'block');$('#vis_ci_attach').val('".$ci_attach_id."');";
				echo "$('#vis_attach_ci').append('".$final_data."');</script>";
			}
		}
		else{
			$department_id=0;
			if(isset($operation['vis_department'])) $department_id=$operation['vis_department'];
			$filter = "and is_enabled=1 and (".VIS_TABLE_PREFIX."itil_configuration_item.department_access = 0 OR FIND_IN_SET($department_id, ".VIS_TABLE_PREFIX."itil_configuration_item.department_access)>0)";
			$confi_item_details=$setting_object->get_configuration_item($filter,0, -1, '', VIS_STAFF_ID);
		
		//	$confi_item_details=$setting_object->get_configuration_item_category('','is_enabled=1');
			include(VIS_PATH_TEMPLATE.'cmdb_attach_ci.php');
		}
        return true;
	}
	
	/*CHANGE CONFIGURATION ITEM ON ATTACH CI TYPE MODEL*/
	function change_cofiguration($operation){
		global $vis_language;
		$database=new class_database();
	    include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'cmdb.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $cmdb_object=new class_cmdb($database);
		$setting_object=new class_setting($database);
		if(VIS_CMDB_VIEW_ACCESS==0){
			echo json_encode(array('vis_msg' => $vis_language['MSGACCSSDND']));
			return false;
		}
		//$filter = VIS_TABLE_PREFIX.'domain.domain_id='.$operation['vis_domain_id'].' AND ';
		$filter = VIS_TABLE_PREFIX.'department.department_id='.$operation['vis_department'].' AND ';
	    if(isset($operation['vis_configuration_id']) && $operation['vis_configuration_id']!=''){
			$filter .= ' '.VIS_TABLE_PREFIX.'itil_cmdb_assets.ci_type_id='.$operation['vis_configuration_id']." AND ";
		}
		if(isset($operation['attached_id']) && $operation['attached_id']!=""){
			$selected_ci=explode(',', $operation['attached_id']);
			for($i=0;$i<count($selected_ci)-1;$i++){
				$filter .= ' assets_id!='.$selected_ci[$i]." AND ";
			}
		}
		$filter=substr($filter, 0, -4);
		
		if(isset($operation['vis_assets_id']) && $operation['vis_assets_id']!=""){
			$filter .= ' AND assets_id!='.$operation['vis_assets_id'];
		}

		
		if(isset($operation['vis_filter_enable']) && $operation['vis_filter']!=''){
			if($filter!=''){$filter .= ' AND ';}
			$filter .= VIS_TABLE_PREFIX."itil_cmdb_assets.name like '%".$operation['vis_filter']."%'";
		}
		
	    $assets_details=$cmdb_object->get_assets($filter,'50', '','',VIS_STAFF_ID, VIS_LOCATION_AREA);
        $tbl_data='';
		if($assets_details!=-1){
				$tbl_data .= '<table class="table table-hover b-t b-light m-b-none">
								<thead class="table_head">
									<tr>
										<th></th>
										<th>'.$vis_language['TXTITEMNAME'].'</th>
										<th>'.$vis_language['TXTCITYPE'].'</th>
										<th>'.$vis_language['TXTUSEDBY'].'</th>						
									</tr>
								</thead>';
			
			for($i=0;$i<count($assets_details);$i++){
				$confi_item_details=$setting_object->get_configuration_item_category($assets_details[$i]['ci_type_id'],'is_enabled=1');
				if(isset($operation['vis_section'])){
					$tbl_data.='<tbody>
								<tr><td><label class="checkbox m-n i-checks"><input type="radio" name="vis_assets_id" id="vis_assets_id" value="'.$assets_details[$i]['assets_id'].'" /><i></i></label></td>';
				}else{
					$tbl_data.='<tr>';
					$tbl_data.='<td><label class="checkbox m-n i-checks"><input type="checkbox" name="vis_attach_id_'.$i.'" id="vis_attach_id_'.$i.'" value="'.$assets_details[$i]['assets_id'].'" /><i></i></label></td>';
				}
				if(isset($operation['vis_section'])){
					$tbl_data.='<td>'.$assets_details[$i]['name'].'</td><td>'.$confi_item_details[0]['name'].'</td><td>'.$assets_details[$i]['usedby'].'</td></tr>';
				}else{
					$tbl_data.='<td>'.$assets_details[$i]['name'].'</td><td>'.$confi_item_details[0]['name'].'</td><td>'.$assets_details[$i]['usedby'].'</td></tr>';
				}
			}
		}else{
			$tbl_data .='<div style="text-align:center;">'.$vis_language['TXTNORECORDFOUND'].'</div>';
			$tbl_data .='<input type="hidden" name="total_itemrecord" id="total_itemrecord" value="0">';
		}
		if($tbl_data==''){
			if(isset($operation['vis_section'])){
				$tbl_data .='<div style="text-align:center;">'.$vis_language['TXTNOMATCHFOUND'].'</div>';
				$tbl_data .='<input type="hidden" name="total_itemrecord" id="total_itemrecord" value="0">';
			}else{
				$tbl_data .='<tr><td colspan="3" align="center"><label class="" for="vis_lastname">'.$vis_language['TXTNOMATCHFOUND'].'</label></td></tr></tbody></table>';
				$tbl_data .='<input type="hidden" name="total_itemrecord" id="total_itemrecord" value="0">';
			}
		}else{
			$tbl_data .='<input type="hidden" name="total_itemrecord" id="total_itemrecord" value="'.count($assets_details).'">';
		}
		echo json_encode(array('list' => $tbl_data));
        return true;
	}
	
	//************CMDB ASSETS SECTION STARTS************************************
	function assets($operation){
		
		global $vis_language;
        $page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
        $sort_by=(isset($operation['vis_sort_by']))?$operation['vis_sort_by']:'';
        $operation['view_title']=$vis_language['TXTASSETS'];
        $filter='';
		$spliter=(strstr($operation['vis_action'], '/'))?'/':',';
        $action=explode($spliter, $operation['vis_action']);
		if(isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)
        {

			$data= isset($operation['vis_action']) && $operation['vis_action']!='' ? parse_form_array($operation['vis_action']) : $operation;             
		    if($data['vis_name']!='') $filter=" ".VIS_TABLE_PREFIX."itil_cmdb_assets.name like '%".$data['vis_name']."%' and ";
		    if($data['vis_ci_type_id']!='') $filter .=" ".VIS_TABLE_PREFIX."itil_cmdb_assets.ci_type_id=".$data['vis_ci_type_id']." and ";
		    if($data['vis_location_id']!='') $filter .=" ".VIS_TABLE_PREFIX."itil_cmdb_assets.location_id=".$data['vis_location_id']." and ";
		    if($data['vis_department']!='') $filter .=" ".VIS_TABLE_PREFIX."itil_cmdb_assets.department_access=".$data['vis_department']." and ";
			if($data['vis_product_id']!='') $filter .=" ".VIS_TABLE_PREFIX."itil_cmdb_assets.product_id=".$data['vis_product_id']." and ";
			if($data['vis_asset_tag']!='') $filter .=" ".VIS_TABLE_PREFIX."itil_cmdb_assets.asset_tag LIKE '%".$data['vis_asset_tag']."%' and ";
			if($data['vis_licence_key']!='') $filter .=" ".VIS_TABLE_PREFIX."itil_cmdb_assets.licence_key =".$data['vis_licence_key']." and ";
			if($data['vis_assets_state']!='') $filter .=" ".VIS_TABLE_PREFIX."itil_cmdb_assets.assets_state =".$data['vis_assets_state']." and ";
			if($data['vis_vendor_id']!='') $filter .=" ".VIS_TABLE_PREFIX."itil_cmdb_assets.vendor_id =".$data['vis_vendor_id']." and ";
			if($data['vis_usedby']!='') $filter .=" ".VIS_TABLE_PREFIX."itil_cmdb_assets.usedby ='".$data['vis_usedby']."' and ";
			if($data['vis_managed_by']!='') $filter .=" ".VIS_TABLE_PREFIX."itil_cmdb_assets.staff_id =".$data['vis_managed_by']." and ";
		}
		if($action[4]=='msg'){
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");</script>';
		}
		$filter=substr($filter, 0, -4);
		
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$staff=new class_staff($database);
        
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'cmdb.php');
        $cmdb_object=new class_cmdb($database);
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $setting_object=new class_setting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
        $object_ticket = new class_ticket($database);
		
		$filter_1 = '';
        $vendor_details=$setting_object->get_ciproduct_list($filter_1,$data='',VIS_STAFF_ID, VIS_LOCATION_AREA,$limit='');
			 
		list($ci_product_info, $product_details)=$setting_object->get_ci_product($filter_1, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		
		$location_details=$setting_object->get_location_category('','is_enabled=1');
		$citype_details=$setting_object->get_configuration_item_category('','is_enabled=1');
        list($view_info, $view_details)=$staff->get_ticket_view(VIS_STAFF_ID, VIS_LOCATION_AREA);
        $limit=($page*$view_info['page_count']).','.$view_info['page_count'];
        $assets_details=$cmdb_object->get_assets($filter, $limit, $page, $sort_by, VIS_STAFF_ID, VIS_LOCATION_AREA);
		$assets_count=$cmdb_object->get_assets($filter, '', $page, $sort_by, VIS_STAFF_ID, VIS_LOCATION_AREA);
        $assets_list_count =($assets_count!=-1)? count($assets_count):0;
        $view_info['page_count']=($assets_details==-1)?0:ceil($assets_list_count/$view_info['page_count']);
		$view_info['view_count']=count($view_details);
        $filter=VIS_TABLE_PREFIX.'department.is_enabled=1 and '.VIS_TABLE_PREFIX.'domain.is_enabled=1';
		$department_details=$object_ticket->get_department($filter, VIS_STAFF_ID, VIS_LOCATION_AREA, VIS_TABLE_PREFIX.'domain.domain_id');		
        $database->database_disconnect();
	    // Code for api - start
        if(VIS_LOCATION_AREA==0) {
			 echo get_xml($assets_details, 'Assets');
			 return true;
		}
	    // Code for api - end
        if((isset($operation['vis_filter_enable']) && $operation['vis_filter_enable']==1)){
			ob_start();
			include(VIS_PATH_TEMPLATE.'cmdb_assets_list.php');
			$assets_list = ob_get_clean();
			ob_end_flush();			
			$select='';
			$select .= "<div class=\"pull-right\">";
			$select .= "<select name=\"pageing\" id=\"paging\" class=\"form-control input-sm selectpicker pull-right paging v-middle\"  onChange=\"javascript:vis_apply_filter(this.value);\">";					  
			for($i=0;$i<$view_info['page_count'];$i++)
				$select.='<option value="'.$i.'" '.(($page==$i)?'selected="selected"':'').'>'.($i+1).'</option>';
			$select .= "</select><div class=\"text-muted pull-right label_page\">".$vis_language['TXTPAGE'].":</div>";
			
			echo json_encode( array('total_cnt'=>$assets_list_count, 'paging' => $select, 'list'=> $assets_list));
		}else 
			include(VIS_PATH_TEMPLATE.'cmdb_assets.php');
        return true;
    }

    function new_cmdb_assets($operation){
		global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'cmdb.php');
        $cmdb_object=new class_cmdb($database);
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $setting_object=new class_setting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $sub_object=new class_subsetting($database);
		include_once(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.'ticket.php');
		$ticket=new ticket($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
		$object_ticket=new class_ticket($database);

		$operation['vis_product_id']='';
		$operation['vis_vendor_id']='';
		$operation['vis_warranty_year']='';
		$operation['vis_warranty_month']='';
		$operation['vis_installation_date']='';
		$operation['vis_expiry_date']='';
		$operation['vis_assets_state']='';
		$operation['vis_asset_tag']='';
		$operation['vis_installation_path']='';
		$operation['vis_licence_key']='';
		$operation['vis_last_audit_date']='';
		$operation['vis_salvage']='';
		$operation['vis_depreciation_type']='';
		//$impact_details=$ticket->get_properties('get_impacts', '');		
		//$citype_details=$setting_object->get_configuration_item_category('','is_enabled=1');
		//$location_details=$setting_object->get_location_category('','is_enabled=1');
		$filter=(VIS_TABLE_PREFIX.'department.is_enabled=1 and '.VIS_TABLE_PREFIX.'domain.is_enabled=1');
		$departments=$object_ticket->get_department($filter, VIS_STAFF_ID, VIS_LOCATION_AREA, VIS_TABLE_PREFIX.'domain.domain_id');
        include(VIS_PATH_TEMPLATE.'cmdb_assets_new.php');
        return true;
	}
	
	function get_custom_fields($operation){
	
        $custom_field_var='';
		$database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'cmdb.php');
        $cmdb_object=new class_cmdb($database);
		
		list($citype_details,$custom_fields_details)=$cmdb_object->get_customfield($operation['ci_type_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
		if($custom_fields_details != -1 && count($custom_fields_details)>0){
			$cc_count=0;
			$custom_field_var .='<div class="line b-b line-lg pull-in"></div><br><div class="form-group"><label class="col-sm-2 control-label" for="'.$citype_details['name'].'"><strong>'.$citype_details['name'].'</strong></label></div>';  
			
			for($j=0; $j<count($custom_fields_details); $j++){
				 $val='';
				if($custom_fields_details[$j]['field_type']<4 || $custom_fields_details[$j]['field_type']==8){
					$custom_data = $cmdb_object->get_customfield_data($custom_fields_details[$j]['customfield_id'],$operation['assets_id']);
					
					if($custom_data != -1)  $val = $custom_data['content'];
					else $val = $custom_fields_details[$j]['default_value'];
					
					$req = ($custom_fields_details[$j]['is_required']==1)?' *':'';
					if($custom_fields_details[$j]['field_type']==1)
					{
					   $custom_field_var.='<input type="hidden" value="'.$custom_fields_details[$j]['customfield_id'].'" id="custom_field_id" name="custom_field_id" class="form-control input-sm">';
						if(($custom_fields_details[$j]['is_staff_editable'] == 1  &&  VIS_LOCATION_AREA == 2 ) || ($custom_fields_details[$j]['is_user_editable'] == 1 &&  VIS_LOCATION_AREA == 1))  
						{
							$custom_field_var.='<div class="form-group"><label class="col-sm-2 control-label" for="'.$custom_fields_details[$j]['field_name'].'" title="'.$custom_fields_details[$j]['field_description'].'">'.$custom_fields_details[$j]['field_name'].$req.'</label><div class="col-sm-8"><input type="text" value="'.$val.'" id="field'.$custom_fields_details[$j]['customfield_id'].'" name="field'.$custom_fields_details[$j]['customfield_id'].'" class="form-control input-sm"></div></div>';
						}
						else
						{
							 $custom_field_var.='<div class="form-group"><label class="col-sm-2 control-label" title="'.$custom_fields_details[$j]['field_description'].'" for="'.$custom_fields_details[$j]['field_name'].'">'.$custom_fields_details[$j]['field_name'].$req.'</label><div class="col-sm-8"><input type="text" value="'.$val.'" readonly name="field'.$custom_fields_details[$j]['customfield_id'].'" id="field'.$custom_fields_details[$j]['customfield_id'].'" class="form-control input-sm"></div></div>';
						}
				   }
					if($custom_fields_details[$j]['field_type']==2)
					{
					   if(($custom_fields_details[$j]['is_staff_editable'] == 1  &&  VIS_LOCATION_AREA == 2 ) || ($custom_fields_details[$j]['is_user_editable'] == 1 &&  VIS_LOCATION_AREA == 1))  
						{
							$custom_field_var.='<div class="form-group"><label class="col-sm-2 control-label" for="'.$custom_fields_details[$j]['field_name'].'" title="'.$custom_fields_details[$j]['field_description'].'">'.$custom_fields_details[$j]['field_name'].$req.'</label><div class="col-sm-8"><input type="password" name="field'.$custom_fields_details[$j]['customfield_id'].'" id="field'.$custom_fields_details[$j]['customfield_id'].'" class="form-control input-sm" value="'.$val.'"></div></div>';
						} 
						else
						{
							$custom_field_var.='<div class="form-group"><label class="col-sm-2 control-label" for="'.$custom_fields_details[$j]['field_name'].'" title="'.$custom_fields_details[$j]['field_description'].'">'.$custom_fields_details[$j]['field_name'].$req.'</label><div class="col-sm-8"><input type="password" name="field'.$custom_fields_details[$j]['customfield_id'].'" id="field'.$custom_fields_details[$j]['customfield_id'].'" class="form-control input-sm" value="'.$val.'" readonly ></div></div>';
						}  
					}
					if( $custom_fields_details[$j]['field_type']==3)
					{
						if(($custom_fields_details[$j]['is_staff_editable'] == 1  &&  VIS_LOCATION_AREA == 2 ) || ($custom_fields_details[$j]['is_user_editable'] == 1 &&  VIS_LOCATION_AREA == 1))  
						{
							$custom_field_var.='<div class="form-group"><label class="col-sm-2 control-label" for="'.$custom_fields_details[$j]['field_name'].'" title="'.$custom_fields_details[$j]['field_description'].'">'.$custom_fields_details[$j]['field_name'].$req.'</label><div class="col-sm-8"><textarea name="field'.$custom_fields_details[$j]['customfield_id'].'" id="field'.$custom_fields_details[$j]['customfield_id'].'" class="form-control input-sm" >'.$val.'</textarea></div></div>';
						}
						else
						{
							 $custom_field_var.='<div class="form-group"><label class="col-sm-2 control-label" for="'.$custom_fields_details[$j]['field_name'].'" title="'.$custom_fields_details[$j]['field_description'].'">'.$custom_fields_details[$j]['field_name'].$req.'</label><div class="col-sm-8"><textarea name="field'.$custom_fields_details[$j]['customfield_id'].'" id="field'.$custom_fields_details[$j]['customfield_id'].'" class="form-control input-sm" readonly>'.$val.'</textarea></div></div>';
						}  
					}
					if($custom_fields_details[$j]['field_type']==8)
					{
					   if(($custom_fields_details[$j]['is_staff_editable'] == 1  &&  VIS_LOCATION_AREA == 2 ) || ($custom_fields_details[$j]['is_user_editable'] == 1 &&  VIS_LOCATION_AREA == 1))  
						{
							if($val=='0' || $val=='')
							{
								$val='';
							}
							else
							{
								$val=date('M-d, Y H:i',strtotime($val));
							}
							 $custom_field_var.='<div class="form-group"><label class="col-sm-2 control-label" title="'.$custom_fields_details[$j]['field_description'].'">'.$custom_fields_details[$j]['field_name'].$req.'</label><div class="col-sm-8"><span class="input-group-addon no-padder no-borders start date"><input type="text" name="field'.$custom_fields_details[$j]['customfield_id'].'" id="field'.$custom_fields_details[$j]['customfield_id'].'" class="form-control input-sm " value="'.$val.'"></span></div></div>';
						}
						else
						{
							 $custom_field_var.='<div class="form-group"><label class="col-sm-2 control-label" title="'.$custom_fields_details[$j]['field_description'].'">'.$custom_fields_details[$j]['field_name'].$req.'</label><div class="col-sm-8"><span class="input-group-addon no-padder no-borders"><input type="text" name="field'.$custom_fields_details[$j]['customfield_id'].'" id="field'.$custom_fields_details[$j]['customfield_id'].'" class="form-control input-sm" value="'.$val.'" readonly ></span></div></div>';
						}
						  
					}                          
					$cc_count++;
				}
				else{
					 $flag = array();     
					$filter='field_group='.$custom_fields_details[$j]['field_group'].' ';
					$sub_customfields_details=$cmdb_object->get_subcustomfield($filter, VIS_STAFF_ID, VIS_LOCATION_AREA,'edit_page');
					
					$sub_customfields_details_lang=$cmdb_object->get_subcustomfield($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
					if($sub_customfields_details != -1){
						if($custom_fields_details[$j]['field_type']==4){
							$custom_field_var.='<div class="form-group"><label class="col-sm-2 control-label" for="'.$custom_fields_details[$j]['field_name'].'" title="'.$custom_fields_details[$j]['field_description'].'">'.addslashes($custom_fields_details[$j]['field_name']).'</label><div class="col-sm-8">';
							for($cnt=0;$cnt< count($sub_customfields_details);$cnt++)
							{
								  $custom_data = $cmdb_object->get_customfield_data($sub_customfields_details[$cnt]['customfield_id'],$operation['assets_id']);  
								  if($custom_data != -1)  
								  {
											 $flag[$cnt] =  1;
								  }
							}
							for($k=0;$k< count($sub_customfields_details);$k++){
							   $custom_data = $cmdb_object->get_customfield_data($sub_customfields_details[$k]['customfield_id'],$operation['assets_id']);   
								if(($custom_data['content'] === $sub_customfields_details[$k]['default_value'])) $sel = 'checked="checked"';
								else if(count($flag) <= 0 &&  $sub_customfields_details[$k]['is_selected'] == 1)  $sel = 'checked="checked"';   
								else $sel='';
								 if(($custom_fields_details[$j]['is_staff_editable'] == 1  &&  VIS_LOCATION_AREA == 2 ) || ($custom_fields_details[$j]['is_user_editable'] == 1 &&  VIS_LOCATION_AREA == 1))                                 		 {
									$custom_field_var.='<label class="checkbox-inline i-checks"><input type="checkbox" '.$sel.' name="field'.$sub_customfields_details[$k]['customfield_id'].'" id="field'.$sub_customfields_details[$k]['customfield_id'].'" value="'.$sub_customfields_details[$k]['default_value'].'" > <i></i> '.$sub_customfields_details_lang[$k]['default_value'].'</label> ';
								}
								else 
								{
									$custom_field_var.='<label class="checkbox-inline i-checks"><input type="checkbox" '.$sel.' name="field'.$sub_customfields_details[$k]['customfield_id'].'" id="field'.$sub_customfields_details[$k]['customfield_id'].'" value="'.$sub_customfields_details[$k]['default_value'].'" disabled="disabled"> <i></i> '.$sub_customfields_details_lang[$k]['default_value'].'</label> ';
								}
								$cc_count++;
							}
							$custom_field_var .= '</div></div>';
						}
						if($custom_fields_details[$j]['field_type']==5){
							$custom_field_var.='<div class="form-group"><label class="col-sm-2 control-label" for="'.$custom_fields_details[$j]['field_name'].'" title="'.$custom_fields_details[$j]['field_description'].'">'.addslashes($custom_fields_details[$j]['field_name']).'</label><div class="col-sm-8">';
							
							$selradid='';
							$defaultradid='';
							for($k=0;$k<count($sub_customfields_details);$k++){
								$custom_data = $cmdb_object->get_customfield_data($sub_customfields_details[$k]['customfield_id'],$operation['assets_id']);  
								if($custom_data['content']== $sub_customfields_details[$k]['default_value']) 
								 $selradid=$sub_customfields_details[$k]['customfield_id'];
								
								if( $sub_customfields_details[$k]['is_selected'] == 1)
									$defaultradid=$sub_customfields_details[$k]['customfield_id'];
								}
							
							for($k=0;$k<count($sub_customfields_details);$k++){
								$custom_data = $cmdb_object->get_customfield_data($sub_customfields_details[$k]['customfield_id'],$operation['assets_id']);  
								
								if(($selradid!='' && $selradid==$sub_customfields_details[$k]['customfield_id']) || ($selradid=='' && $defaultradid==$sub_customfields_details[$k]['customfield_id']))
								{
									$sel = 'checked="checked"';
								}
								else
								{
									$sel = '';
								}
								
								/*if(($custom_data['content']== $sub_customfields_details[$k]['default_value']) || $sub_customfields_details[$k]['is_selected'] == 1) $sel = 'checked="checked"';
								else $sel='';*/
								 if(($custom_fields_details[$j]['is_staff_editable'] == 1  &&  VIS_LOCATION_AREA == 2 ) || ($custom_fields_details[$j]['is_user_editable'] == 1 &&  VIS_LOCATION_AREA == 1))                                 		 {
								  $custom_field_var.='<div class="radio i-checks m-r-lg pull-left"><label><input type="radio" '.$sel.' name="field'.$custom_fields_details[$j]['customfield_id'].'[]" id="field'.$sub_customfields_details[$k]['customfield_id'].'" value="'.addslashes($sub_customfields_details[$k]['customfield_id'].'-'.$sub_customfields_details[$k]['default_value']).'"> <i></i> '.$sub_customfields_details_lang[$k]['default_value'].'</label></div>';
								 }
								 else
								 {
									$custom_field_var.='<div class="radio i-checks m-r-lg pull-left"><label><input type="radio" '.$sel.' name="field'.$custom_fields_details[$j]['customfield_id'].'[]" id="field'.$sub_customfields_details[$k]['customfield_id'].'" value="'.addslashes($sub_customfields_details[$k]['customfield_id'].'-'.$sub_customfields_details[$k]['default_value']).'" disabled="disabled"> <i></i> '.$sub_customfields_details_lang[$k]['default_value'].'</label></div>';
								 }
								$cc_count++;
							}
							$custom_field_var .= '</div></div>';
						}
						if($custom_fields_details[$j]['field_type']==6){
						if(($custom_fields_details[$j]['is_staff_editable'] == 1  &&  VIS_LOCATION_AREA == 2 ) || ($custom_fields_details[$j]['is_user_editable'] == 1 &&  VIS_LOCATION_AREA == 1))                                 	 {
							$custom_field_var.='<div class="form-group"><label class="col-sm-2 control-label" for="'.$custom_fields_details[$j]['field_name'].'" title="'.$custom_fields_details[$j]['field_description'].'">'.addslashes($custom_fields_details[$j]['field_name']).'</label><div class="col-sm-8"><select name="field'.$custom_fields_details[$j]['customfield_id'].'" id="field'.$custom_fields_details[$j]['customfield_id'].'" class="form-control selectpicker">';
							 }
							 else
							 {
								 $custom_field_var.='<div class="form-group"><label class="col-sm-2 control-label" for="'.$custom_fields_details[$j]['field_name'].'" title="'.$custom_fields_details[$j]['field_description'].'">'.addslashes($custom_fields_details[$j]['field_name']).'</label><div class="col-sm-8"><select disabled="disabled" name="field'.$custom_fields_details[$j]['customfield_id'].'" id="field'.$custom_fields_details[$j]['customfield_id'].'" class="form-control selectpicker">';
							 }
							 $tmpselect='';$defaultsel='';$tt='';
							for($k=0;$k<count($sub_customfields_details);$k++) {
								 $custom_data = $cmdb_object->get_customfield_data($sub_customfields_details[$k]['customfield_id'],$operation['assets_id']);  
								
								if($custom_data['content']== $sub_customfields_details[$k]['default_value']) 
									{
										 $tmpselect=$sub_customfields_details[$k]['customfield_id'];
										
								    }
								
								if( $sub_customfields_details[$k]['is_selected'] == 1)
								{
									$defaultsel=$sub_customfields_details[$k]['customfield_id'];
									
								}
							}
							for($k=0;$k<count($sub_customfields_details);$k++) {
								 $custom_data = $cmdb_object->get_customfield_data($custom_fields_details[$j]['customfield_id'],$operation['assets_id']);
								if(($tmpselect!='' && $tmpselect==$sub_customfields_details[$k]['customfield_id']) || ($tmpselect=='' && $defaultsel==$sub_customfields_details[$k]['customfield_id']))
								{
									 $sel = 'selected="selected"';
								}
								else
								{
									$sel = '';
								}
									$custom_field_var.='<option value="'.addslashes($sub_customfields_details[$k]['default_value']).'" '.$sel.'>'.addslashes($sub_customfields_details_lang[$k]['default_value']).'</option>';
							}
							
							$custom_field_var.='</select></div></div>';
							$cc_count++;
						}
						if($custom_fields_details[$j]['field_type']==7){
						if(($custom_fields_details[$j]['is_staff_editable'] == 1  &&  VIS_LOCATION_AREA == 2 ) || ($custom_fields_details[$j]['is_user_editable'] == 1 &&  VIS_LOCATION_AREA == 1))                               	 {
								$custom_field_var.='<div class="form-group"><label class="col-sm-2 control-label" for="'.$custom_fields_details[$j]['field_name'].'" title="'.$custom_fields_details[$j]['field_description'].'">'.addslashes($custom_fields_details[$j]['field_name']).'</label><div class="col-sm-8"><select name="field'.$custom_fields_details[$j]['customfield_id'].'[]" id="field'.$custom_fields_details[$j]['customfield_id'].'" multiple="multiple" size="5" class="form-control input-sm selectpicker">';
							 }
							 else
							 {
								$custom_field_var.='<div class="form-group"><label class="col-sm-2 control-label" for="'.$custom_fields_details[$j]['field_name'].'" title="'.$custom_fields_details[$j]['field_description'].'">'.addslashes($custom_fields_details[$j]['field_name']).'</label><div class="col-sm-8"><select disabled="disabled" name="field'.$custom_fields_details[$j]['customfield_id'].'[]" id="field'.$custom_fields_details[$j]['customfield_id'].'" multiple="multiple" size="5" class="form-control input-sm selectpicker">';
							 }
							for($cnt=0;$cnt< count($sub_customfields_details);$cnt++)
							{
								  $custom_data = $cmdb_object->get_customfield_data($sub_customfields_details[$cnt]['customfield_id'],$operation['assets_id']);  
								  if($custom_data != -1)  
								  {
											 $flag[$cnt] =  1;
								  }
							}
							for($k=0;$k<count($sub_customfields_details);$k++) {
								$custom_data = $cmdb_object->get_customfield_data($sub_customfields_details[$k]['customfield_id'],$operation['assets_id']);
								
								if(($custom_data['content']== $sub_customfields_details[$k]['default_value'])) {$sel = 'selected="selected"'; }
								else $sel='';  
								if(count($flag) == 0 && $sub_customfields_details[$k]['is_selected'] == 1)$sel = 'selected="selected"'; 
								   $custom_field_var.='<option value="'.addslashes($sub_customfields_details[$k]['customfield_id'].'-'.$sub_customfields_details[$k]['default_value']).'" '.$sel.'>'.addslashes($sub_customfields_details_lang[$k]['default_value']).'</option>';
							}
							$custom_field_var.='</select></div></div>';
							$cc_count++;
						}
					}
				}
			}
		}else $custom_field_var='';
		if($operation['assetflg']=='1')
		{
		return $custom_field_var;
		}
		else
		echo json_encode($custom_field_var);
    }
	
	function get_filterdata_list($operation){
		global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$staff_object=new class_staff($database); 
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $object=new class_setting($database);
		list($operation['domain_id'], $operation['vis_department_id'])=explode(':', $operation['vis_department_id']);
		$department_id=$operation['vis_department_id'];
		$filter='';
		$staff='';
		$ci_type='';
		$impact='';
		$location='';
		$staff_list = $staff_object->get_staff('is_enabled=1',VIS_STAFF_ID, VIS_LOCATION_AREA, $department_id);
		$search = (count($staff_list)>10)? 'data-live-search="true"' : '';
		$staff .= "<select name=\"vis_managed_by\" id=\"vis_managed_by\" class=\"form-control input-sm  selectpicker\" ".$search." >";
		$staff .= "<option value=''>".$vis_language['TXTSELECT']."</option>";
		if($staff_list!=-1){
			$selected='';
			for($i=0;$i<count($staff_list);$i++){
				if(isset($operation['vis_staff_id']) && $operation['vis_staff_id']!=''){
					$selected = ($operation['vis_staff_id']==$staff_list[$i]['staff_id'])?'selected="selected"':'';
				}
				$staff.='<option value="'.$staff_list[$i]['staff_id'].'" '.$selected.'>'.$staff_list[$i]['first_name'].' '.$staff_list[$i]['last_name'].'</option>';
			}
		}
		$staff .= "</select>";
		
		$filter = " and is_enabled=1 and (".VIS_TABLE_PREFIX."itil_configuration_item.department_access = 0 OR FIND_IN_SET($department_id, ".VIS_TABLE_PREFIX."itil_configuration_item.department_access)>0)";
		$config_details=$object->get_configuration_item($filter,0, -1, '', VIS_STAFF_ID);
		//$search = (count($config_details)>10)? 'data-live-search="true"' : '';
		$ci_type .= "<select name=\"vis_ci_type_id\" onchange=\"set_property(this.value,'".$department_id."');\" id=\"vis_ci_type_id\" class=\"form-control input-sm  selectpicker\" data-live-search=\"true\" >";
		$ci_type .= "<option value=''>".$vis_language['TXTSELECT']."</option>";
		$ci_type .= $this->vis_show_subcategories($config_details,'','ci');
		$ci_type .= "</select>";
		
		$filter = " and (".VIS_TABLE_PREFIX."itil_location.department_access = 0 OR FIND_IN_SET($department_id, ".VIS_TABLE_PREFIX."itil_location.department_access)>0)";
		$location_details=$object->get_locations($filter,0, -1, '', VIS_STAFF_ID);
		$search = (count($location_details)>10)? 'data-live-search="true"' : '';
		$location .= "<select name=\"vis_location_id\" id=\"vis_location_id\" class=\"form-control input-sm  selectpicker\" ".$search." >";
		$location .= "<option value=''>".$vis_language['TXTSELECT']."</option>";
		$location .= $this->vis_show_subcategories($location_details,'','location');
		$location .= "</select>";
		
	$filter = "(".VIS_TABLE_PREFIX."itil_impact.department_access = 0 OR FIND_IN_SET($department_id, ".VIS_TABLE_PREFIX."itil_impact.department_access)>0) and ".VIS_TABLE_PREFIX."itil_impact.is_enabled=1";
		list($impact_info, $impact_details)=$object->get_impact($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$search = ($impact_info['total']>10)? 'data-live-search="true"' : '';
		$impact .= "<select name=\"vis_impact_id\" id=\"vis_impact_id\" class=\"form-control input-sm  selectpicker\" ".$search." >";
		$impact .= "<option value=''>".$vis_language['TXTSELECT']."</option>";
		if($impact_details!=-1){
			$selected='';
			for($i=0;$i<count($impact_details);$i++){
				if(isset($operation['vis_impact_id']) && $operation['vis_impact_id']!=''){
					$selected = ($operation['vis_impact_id']==$impact_details[$i]['impact_id'])?'selected="selected"':'';
				}
				$impact.='<option value="'.$impact_details[$i]['impact_id'].'" '.$selected.'>'.$impact_details[$i]['name'].'</option>';
			}
		}
		$impact .= "</select>";
		
		
		echo json_encode( array('staff_list'=>$staff,'citype_list'=>$ci_type,'impact_list'=>$impact, 'location_list'=>$location));
	}
	function vis_show_subcategories($config_details,$call,$flag) {
		if($flag=='ci')
			$id='item_id';
		elseif($flag=='location')
			$id='location_id';
			
		for($i=0;$i<count($config_details);$i++) { 
				$options .='<option value="'.$config_details[$i][$id].'">'.$config_details[$i]['name'].'</option>';
				if(isset($config_details[$i]['subcat']) && $config_details[$i]['subcat']!=NULL) { 
					$options .=$this->vis_show_subcategories($config_details[$i]['subcat'],'sub_cat',$flag); 
				}
			}
		return $options;
	}
	function get_staff_client_details($operation){
		global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'cmdb.php');
		$cmdb_object=new class_cmdb($database); 
		$details = $cmdb_object->get_staff_cleint_details($operation['vis_data'],VIS_STAFF_ID, VIS_LOCATION_AREA);
		
		$result='[';
        if($details!=-1) for($i=0;$i<count($details);$i++) {
            $result.='{"id":"'.$details[$i]['ID'].'", "full_name":"'.str_replace("\'","'",trim($details[$i]['STFNAME'])).' '.str_replace("\'","'",trim($details[$i]['STLNAME'])).'","email":"'.trim($details[$i]['STEMAIL']).'"},';
        }
        $result=substr($result, 0, -1);
        if($result=='') return false;
        $result.=']';
        if(VIS_LOCATION_AREA==0) 
			echo get_xml($client, 'client');
        else 
			echo $result;
        return true;
	}
	
	function add_ci($operation) {
		global $vis_language;
		$operation['view_title']=$vis_language['TXTASSETS'];	
        $data=parse_form_array($operation['vis_action']);
		$name = str_replace(",,",",",$operation['vis_attach_name']);
		$tmp_name=rtrim($name, ",");
		$data['vis_attach_name']=$tmp_name;
	    $mystring = $data['vis_name'];
		$findme   = '/';
		$pos = strpos($mystring, $findme);
		if(VIS_LOCATION_AREA!=0){
			if(is_numeric($pos)) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGTILALPHNUM'].'"); </script>';
				return false;
			}elseif(!isset($data['vis_name']) || trim($data['vis_name'])=='') {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFLDNAME'].'"); </script>';
				return false;
			}
			if(((!isset($data['vis_department'])) || $data['vis_department']=='0')) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQUIREDFIELDDEPARTMENT'].'"); </script>';
				return false;
			}
			if(!isset($data['vis_ci_type_id']) || trim($data['vis_ci_type_id'])=='') {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFLDCITYPE'].'"); </script>';
				return false;
			}
			if(isset($data['vis_product_id']) && $data['vis_product_id']==0) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFLDPRODUCT'].'"); </script>';
				return false;
			}
			if(isset($data['vis_assets_state']) && $data['vis_assets_state']==0 && $data['vis_ci_type_id']==2) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFLDASSETSTATE'].'"); </script>';
				return false;
			}
		}
		if(VIS_LOCATION_AREA==0){
			$data = $operation;
			if($data['vis_ci_type_id']==2){
				$data['vis_installation_date'] = $data['vis_acquisition_date'];
				$data['vis_expiry_date'] = $data['vis_warranty_expiry_date'];
				$data['vis_licence_key'] = $data['vis_serial_number'];
				$data['vis_installation_path'] = $data['vis_cost'];
			}
			if($data['vis_ci_type_id']==2){
				$data['vis_assets_state'] = $data['vis_license_type'];
				$data['vis_asset_tag'] = $data['vis_cost'];
				$data['vis_expiry_date'] = $data['vis_license_expiry_date'];
			}
			
		}
		/*if(isset($data['vis_assets_state']) && $data['vis_assets_state']==0 && $data['vis_ci_type_id']==3) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFLDLICENCETYPE'].'"); </script>';
            return false;
        }*/		
		
        if (defined('VIS_HTML_EDITOR') && VIS_HTML_EDITOR != 1) 
        $data['vis_description'] = str_replace(array("\r\n","\r","\n"),"<br>",$data['vis_description']);
		$database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
		$sub_object=new class_subsetting($database);
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'cmdb.php');
		$cmdb_object=new class_cmdb($database);
		list($dimain_id, $dept_id)=explode(':', $data['vis_department']);
		if(!$cmdb_object->valid_ciname($data['vis_name'],$data['vis_ci_type_id'],$dept_id))
		{
			  echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINVALIDASSETNAME'].'"); </script>';
            return false;
		}
		$check_custom=$cmdb_object->check_cmdbcustom_data($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if(!$check_custom[0])
		{
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGINFOMISS'].'('.$check_custom[1].')"); </script>';
				return false;
		}
		$ret=$cmdb_object->add_ci_data($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if(VIS_LOCATION_AREA==0){
			if(!$ret) {
				echo 'error in operation';
				return false;
			}
			else {
				$activity_log=$sub_object->add_staff_activity_log("Added new CI ".$data['vis_name'], VIS_STAFF_ID,'', VIS_LOCATION_AREA);
				echo 'Success';
			}			
		}else{	
			if(!$ret) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGERROPRT'].'"); </script>';
				return false;
			}
			else {
				$activity_log=$sub_object->add_staff_activity_log("Added new CI ".$data['vis_name'], VIS_STAFF_ID,'', VIS_LOCATION_AREA);
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTASSETS'].'",{"vis_module":"cmdb", "vis_operation":"assets"}); </script>';
			}
		}
        $database->database_disconnect();
        return true;
    }
	
	function cmdb_assets_details($operation){
		global $vis_language;
        $spliter=(strstr($operation['vis_action'], '/'))?'/':',';
		$action=explode($spliter, $operation['vis_action']);
		if(isset($action[4]) && $action[4]!='' && is_numeric($action[4])) {
			
            $database=new class_database();
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'cmdb.php');
			$cmdb_object=new class_cmdb($database);
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
			$setting_object=new class_setting($database);
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
			$sub_object=new class_subsetting($database);
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
			$staff_object=new class_staff($database);			
			include_once(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.'ticket.php');
			$ticket=new ticket($database);
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
			$object_ticket=new class_ticket($database);
		
            $filter=VIS_TABLE_PREFIX.'itil_cmdb_assets.assets_id='.$action[4].' ';
			$assets_details=$cmdb_object->get_assets($filter, 1, 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
			$assets_details=$assets_details[0];
			$staff=$staff_object->get_staff(VIS_TABLE_PREFIX.'staff.staff_id='.$assets_details['staff_id'], '', '');
			if($assets_details['attachment_id']!=''){
				$files= explode(',', $assets_details['attachment_id']);
				for($i=0;$i<count($files)-1;$i++){
					$assets_details['files'][]=$cmdb_object->get_uploaded_file('attachment_id='.$files[$i], '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
				}
			}
			if($assets_details['depreciation_type']!=0){
				$filter4 ='finance_id='.$assets_details['depreciation_type'];
				$depreciation_details=$setting_object->get_finance_management_list($filter4,$data='',VIS_STAFF_ID, VIS_LOCATION_AREA,$limit='');
			}
	
			$impact_details=$ticket->get_properties('get_impacts', '');	
			$citype_details=$setting_object->get_configuration_item_category('','is_enabled=1');
			$location_details=$setting_object->get_location_category('','is_enabled=1');
			$filter=VIS_TABLE_PREFIX.'department.is_enabled=1 and '.VIS_TABLE_PREFIX.'domain.is_enabled=1 and department_id='.$assets_details['department_access'];
			$assets_department=$object_ticket->get_department($filter, VIS_STAFF_ID, VIS_LOCATION_AREA, VIS_TABLE_PREFIX.'domain.domain_id');
			$assets_domain=$object_ticket->get_domain(VIS_TABLE_PREFIX.'domain.is_enabled=1 and '.VIS_TABLE_PREFIX.'domain.domain_id='.$assets_department[0]['domain_id'], VIS_STAFF_ID,VIS_LOCATION_AREA);
          
            $operation['view_title']=$vis_language['TXTASSETS'];
             if(VIS_LOCATION_AREA==2)
			{
				include(VIS_PATH_TEMPLATE.'assets_details.php');
			}
			else if(VIS_LOCATION_AREA==1 && IS_LOGIN){
				$filter =VIS_TABLE_PREFIX."itil_ci_product.ci_type_id=".$assets_details['ci_type_id'];
				list($ci_product_info, $product_details)=$setting_object->get_ci_product($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
				$header_title=$vis_language['TXTASSETS'];
				$vis_title=$vis_language['TXTASSETS'];	
				$breadcrumb['Home'] = 'index.php'; 
				$vis_count =  $assets_list_count;
				$breadcrumb[$vis_language['TXTASSETS']] = '?/client/get_ci_list';
				if(!defined('IS_WHMCS')) include(VIS_PATH_TEMPLATE.'header.php');
				else echo '<link href="'.VIS_PORTAL_URL.VIS_PATH_STYLE.'vis_style.css" rel="stylesheet" />';
				include(VIS_PATH_TEMPLATE.'assets_details.php');
				if(!defined('IS_WHMCS')) include(VIS_PATH_TEMPLATE.'footer.php');
			}
			else {
				$assets_details=-1;
				if(VIS_LOCATION_AREA==1 && IS_LOGIN==0){
                if(!defined('IS_WHMCS')) include(VIS_PATH_TEMPLATE.'header.php');
                include(VIS_PATH_TEMPLATE.'login.php');
                include(VIS_PATH_TEMPLATE.'footer.php');
                break;
            }            
				$operation['message']='<center><div class="vis_error_message">'.$vis_language['MSGACCSSDND'].'</div></center>';
			}
			$database->database_disconnect();
			return true;
        }
        else {
            $this->error=$vis_language['MSGINFOMISS'];
            return false;
        }
	}
	
	function get_audit_log_list($operation)
	{
		global $vis_language;
		        if(isset($operation['vis_assets_id']) && is_numeric($operation['vis_assets_id'])) {
                $database=new class_database();
                include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'cmdb.php');
                $cmdb_object=new class_cmdb($database);
                include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');  
                $staff=new class_staff($database);
		        list($view_info, $view_details)=$staff->get_ticket_view(VIS_STAFF_ID, VIS_LOCATION_AREA);
                $page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;     
			    $limit=($page*$view_info['page_count']).','.$view_info['page_count'];	
                list($audit_log_info, $audit_log)=$cmdb_object->audit_log($operation['vis_assets_id'], $limit, $page, VIS_STAFF_ID, VIS_LOCATION_AREA, 1);
                $view_info['page_count']=($audit_log_info['total']==0)?0:ceil($audit_log_info['total']/$view_info['page_count']);
			    $audit_log_info['page']=$page;
			    $view_info['view_count']=count($view_details);
                $audit_count=($audit_log==-1)?0:count($audit_log);
				
				for($i=0 ; $i<$audit_count ; $i++)
                    {
						
						switch($audit_log[$i]['operation_id']) {
							
							case '101':
							
							if($audit_log[$i]['new_info']=="update")
							{ $audit_log[$i]['audit_log_operation']= $audit_log[$i]['description'].' '.$vis_language['MSGUPDATECMDB']; }
							else{
							$audit_log[$i]['audit_log_operation']= $vis_language['TXTNEW'].' '.$audit_log[$i]['description'].' '.$vis_language['MSGNEWCMDB'];}
							break;
							
							case '102':
						    include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
			                $object_ticket=new class_ticket($database);
								$filter=' department_id='.$audit_log[$i]['description'];
								$assets_department=$object_ticket->get_department($filter, VIS_STAFF_ID, VIS_LOCATION_AREA,VIS_TABLE_PREFIX.'domain.domain_id');
								$dept=$assets_department[0]['department_name'];
								if($audit_log[$i]['new_info']=="update")
								{$audit_log[$i]['audit_log_operation']=$vis_language['TXTDEPARTMENT'].' '.$vis_language['TXTUPDATEDTO'].' '.$dept;}
							    else{
								$audit_log[$i]['audit_log_operation']=$vis_language['DEPTSETTO'].' '.$dept;
								}
							break;
							
							case '103':
							include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
							$setting_object=new class_setting($database);
							$item_id=$audit_log[$i]['description'];
			                $citype_details=$setting_object->get_configuration_item_category($item_id,'is_enabled=1');
							$ci_item=$citype_details[0]['description'];
							if($audit_log[$i]['new_info']=="update")
							{$audit_log[$i]['audit_log_operation']=$vis_language['TXTCITYPE'].' '.$vis_language['TXTUPDATEDTO'].' '.$ci_item;}	
						    else{
							$audit_log[$i]['audit_log_operation']=$vis_language['CITYPESETTO'].' '.$ci_item;}
							break;
							
							case '104':
							include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
							$setting_object=new class_setting($database);
							$filter='impact_id='.$audit_log[$i]['description'];
							$impact_details=$setting_object->get_impact($filter,'','','',VIS_STAFF_ID,VIS_LOCATION_AREA);
							$impact=$impact_details[1][0]['description'];
							if($audit_log[$i]['new_info']=="update")
							{$audit_log[$i]['audit_log_operation']=$vis_language['TXTIMPACT'].' '.$vis_language['TXTUPDATEDTO'].' '.$impact;}
						    else{
							$audit_log[$i]['audit_log_operation']=$vis_language['IMPACTSETTO'].' '.$impact;
							}
							break;
							
							case '105':
							include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');  
							$object=new class_setting($database);
							$staff_details=$object->get_staff(VIS_TABLE_PREFIX.'staff.staff_id='.$audit_log[$i]['description'], '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
							$staff_name =  $staff_details[1][0]['first_name'].' '.$staff_details[1][0]['last_name'];
							if($audit_log[$i]['new_info']=="update")
							{$audit_log[$i]['audit_log_operation']=$vis_language['TXTMANAGEDBY'].' '.$vis_language['TXTUPDATEDTO'].' '.$staff_name;}
						    else{
							$audit_log[$i]['audit_log_operation']=$vis_language['TXTMANAGEDBY'].' '.$staff_name;
							}
							break;
							
							case '106':
							if($audit_log[$i]['new_info']=="update")
							{ $audit_log[$i]['audit_log_operation']= $vis_language['TXTUSEDBY'].' '.$vis_language['TXTUPDATEDTO'].' '.$audit_log[$i]['description']; }
						    else{
							$audit_log[$i]['audit_log_operation']= $vis_language['TXTUSEDBY'].' '.$audit_log[$i]['description'];}
							break;
							
							case '107':
							include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
			                $setting_object=new class_setting($database);
							$location_id=$audit_log[$i]['description'];
							$location_details=$setting_object->get_location_category($location_id,'is_enabled=1');
							$location=$location_details[0]['name'];
							if($audit_log[$i]['new_info']=="update")
							{$audit_log[$i]['audit_log_operation']=$vis_language['TXTLOCATION'].' '.$vis_language['TXTUPDATEDTO'].' '.$location;}
							else{	
							$audit_log[$i]['audit_log_operation']=$vis_language['TXTLOCSETTO'].' '.$location;
							}
							break;
							
							case '108':
							if($audit_log[$i]['new_info']=="update")
							{$audit_log[$i]['audit_log_operation']= $vis_language['TXTASSIGNEDON'].' '.$vis_language['TXTUPDATEDTO'].' '.format_datetime($audit_log[$i]['description']);}
						    else{
							$audit_log[$i]['audit_log_operation']= $vis_language['TXTASSIGNEDON'].' '.format_datetime($audit_log[$i]['description']);}
							break;
							
							case '109':
							if($audit_log[$i]['new_info']=="update")
							{$audit_log[$i]['audit_log_operation']= $vis_language['TXTATTACHFILE'].' '.$vis_language['TXTUPDATEDTO'].' '.$audit_log[$i]['description'];}
						    else{
							$audit_log[$i]['audit_log_operation']= $vis_language['TXTATTACHFILE'].' '.$audit_log[$i]['description'];}
						    
							break;
							
							case '110':
							include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
                            $setting=new class_setting($database);
							$filter='product_id='.$audit_log[$i]['description'];
							list($ci_product_info, $product_details)=$setting->get_ci_product($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
							$product=$product_details[0]['name'];
							if($audit_log[$i]['new_info']=="update")
							{$audit_log[$i]['audit_log_operation']= $vis_language['TXTPRODUCT'].' '.$vis_language['TXTUPDATEDTO'].' '.$product;}
						    else{
							$audit_log[$i]['audit_log_operation']= $vis_language['TXTPRODUCT'].' '.$vis_language['TXTSETTO'].' '.$product;}
							break;
							
							case '111':
							include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
                            $setting=new class_setting($database);
							$filter='p.vendor_id='.$audit_log[$i]['description'];
							$vendor_details=$setting->get_ciproduct_list($filter,$data='',VIS_STAFF_ID, VIS_LOCATION_AREA,$limit='');
							$vendor=$vendor_details[0]['vendor_name'];
							if($audit_log[$i]['new_info']=="update")
							{$audit_log[$i]['audit_log_operation']= $vis_language['TXTVENDOR'].' '.$vis_language['TXTUPDATEDTO'].' '.$vendor;}	
						    else{
							$audit_log[$i]['audit_log_operation']= $vis_language['TXTVENDOR'].' '.$vis_language['TXTSETTO'].' '.$vendor;}
							break;
							
							case '112':
							if($audit_log[$i]['new_info']=="update")
							{$audit_log[$i]['audit_log_operation']= $vis_language['TXTITILWARRANTY'].' '.$vis_language['TXTUPDATEDTO'].' '.$audit_log[$i]['description'].' '.$vis_language['TXTYEAR'].' '.$audit_log[$i]['old_info'].' '.$vis_language['TXTMONTH'];}
						    else{
							$audit_log[$i]['audit_log_operation']= $vis_language['TXTITILWARRANTY'].' '.$vis_language['TXTSETTO'].' '.$audit_log[$i]['description'].' '.$vis_language['TXTYEAR'].' '.$audit_log[$i]['old_info'].' '.$vis_language['TXTMONTH'];
							}
							break;
							
							case '113':
							
							if($audit_log[$i]['channel_id']==1){
							if($audit_log[$i]['new_info']=="update"){
							$audit_log[$i]['audit_log_operation']=$vis_language['TXTITILACQUISITIONDATE'].' '.$vis_language['TXTUPDATEDTO'].' '.format_datetime($audit_log[$i]['description']);	
							}
							else{
							$audit_log[$i]['audit_log_operation']=$vis_language['TXTITILACQUISITIONDATE'].' '.$vis_language['TXTSETTO'].' '.format_datetime($audit_log[$i]['description']);} }
							
							if($audit_log[$i]['channel_id']==2){
							if($audit_log[$i]['new_info']=="update"){
							$audit_log[$i]['audit_log_operation']=$vis_language['TXTITILINSTALLATIONDATE'].' '.$vis_language['TXTUPDATEDTO'].' '.format_datetime($audit_log[$i]['description']);	
							}
							else{
							$audit_log[$i]['audit_log_operation']=$vis_language['TXTITILINSTALLATIONDATE'].' '.$vis_language['TXTSETTO'].' '.format_datetime($audit_log[$i]['description']);}}
							    
						    break;
							
							case '114':
							if($audit_log[$i]['channel_id']==1){
							if($audit_log[$i]['new_info']=="update"){
							$audit_log[$i]['audit_log_operation']=$vis_language['TXTITILWARRANTYEXPDATE'].' '.$vis_language['TXTUPDATEDTO'].' '.format_datetime($audit_log[$i]['description']);
							}
							else{
							$audit_log[$i]['audit_log_operation']=$vis_language['TXTITILWARRANTYEXPDATE'].' '.$vis_language['TXTSETTO'].' '.format_datetime($audit_log[$i]['description']); } }
							
							if($audit_log[$i]['channel_id']==2){
							if($audit_log[$i]['new_info']=="update"){
							$audit_log[$i]['audit_log_operation']=$vis_language['TXTITILLICENSEEXPDATE'].' '.$vis_language['TXTUPDATEDTO'].' '.format_datetime($audit_log[$i]['description']);}
							else{
							$audit_log[$i]['audit_log_operation']=$vis_language['TXTITILLICENSEEXPDATE'].' '.$vis_language['TXTSETTO'].' '.format_datetime($audit_log[$i]['description']); } }
							break;
							
							case '115':
							include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
                            $setting=new class_setting($database);
							$filter='asset_id='.$audit_log[$i]['description'];
							list($asset_state_info, $asset_state_details)=$setting->get_asset_state($filter, $limit='', $page='', $sort_by='', VIS_STAFF_ID, VIS_LOCATION_AREA);
							$filter1='license_type_id='.$audit_log[$i]['description'];
							list($license_type_info, $license_type_details)=$setting->get_license_type($filter1, $limit, $page, $sort_by, VIS_STAFF_ID, VIS_LOCATION_AREA);
							$state=$asset_state_details[0]['name'];
							$lictype=$license_type_details[0]['description'];
							if($audit_log[$i]['channel_id']==1){
							if($audit_log[$i]['new_info']=="update")
							{
							$audit_log[$i]['audit_log_operation']= $vis_language['TXTASSETSTATE'].' '.$vis_language['TXTUPDATEDTO'].' '.$state;
							}
							else{
							$audit_log[$i]['audit_log_operation']= $vis_language['TXTASSETSTATE'].' '.$vis_language['TXTSETTO'].' '.$state;}
							}
							if($audit_log[$i]['channel_id']==2)
							{
							if($audit_log[$i]['new_info']=="update")
							{ 
						    $audit_log[$i]['audit_log_operation']= $vis_language['TXTLICENSETYPE'].' '.$vis_language[  'TXTUPDATEDTO'].' '.$lictype;}
							else{
							$audit_log[$i]['audit_log_operation']= $vis_language['TXTLICENSETYPE'].' '.$vis_language['TXTSETTO'].' '.$lictype;}
							}
							break;
							
							case '116':
                            if($audit_log[$i]['channel_id']==1){
							if($audit_log[$i]['new_info']=="update")
							{ $audit_log[$i]['audit_log_operation']=$vis_language['TXTITILASSETTAG'].' '.$vis_language['TXTUPDATEDTO'].' '.$audit_log[$i]['description']; }	
                            else{						
							$audit_log[$i]['audit_log_operation']=$vis_language['TXTITILASSETTAG'].' '.$vis_language['TXTSETTO'].' '.$audit_log[$i]['description'];}
							}
							if($audit_log[$i]['channel_id']==2){
							if($audit_log[$i]['new_info']=="update")
							{ $audit_log[$i]['audit_log_operation']=$vis_language['TXTCOST'].' '.$vis_language['TXTUPDATEDTO'].' '.$audit_log[$i]['description'];}
						    else{
							$audit_log[$i]['audit_log_operation']=$vis_language['TXTCOST'].' '.$vis_language['TXTSETTO'].' '.$audit_log[$i]['description'];}
							}
							break;
							
							case '117':
							if($audit_log[$i]['channel_id']==1){
							if($audit_log[$i]['new_info']=="update")
							{$audit_log[$i]['audit_log_operation']=$vis_language['TXTITILSERIALNUMBER'].' '.$vis_language['TXTUPDATEDTO'].' '.$audit_log[$i]['description'];}
						    else{
                            $audit_log[$i]['audit_log_operation']=$vis_language['TXTITILSERIALNUMBER'].' '.$vis_language['TXTSETTO'].' '.$audit_log[$i]['description'];}
							}
							if($audit_log[$i]['channel_id']==2){
							if($audit_log[$i]['new_info']=="update")
							{$audit_log[$i]['audit_log_operation']=$vis_language['TXTITILLICENSEKEY'].' '.$vis_language['TXTUPDATEDTO'].' '.$audit_log[$i]['description'];}
						    else{
							$audit_log[$i]['audit_log_operation']=$vis_language['TXTITILLICENSEKEY'].' '.$vis_language['TXTSETTO'].' '.$audit_log[$i]['description'];}
							}
                            break;
							
							case '118':
							if($audit_log[$i]['channel_id']==1){
							if($audit_log[$i]['new_info']=="update")
							{ $audit_log[$i]['audit_log_operation']=$vis_language['TXTCOST'].' '.$vis_language['TXTUPDATEDTO'].' '.$audit_log[$i]['description'];}
						    else{
                            $audit_log[$i]['audit_log_operation']=$vis_language['TXTCOST'].' '.$vis_language['TXTSETTO'].' '.$audit_log[$i]['description'];}
							}
							if($audit_log[$i]['channel_id']==2){
							if($audit_log[$i]['new_info']=="update")
							{$audit_log[$i]['audit_log_operation']=$vis_language['TXTITILINSTALLATIONPATH'].' '.$vis_language['TXTUPDATEDTO'].' '.$audit_log[$i]['description'];}
						    else{
							$audit_log[$i]['audit_log_operation']=$vis_language['TXTITILINSTALLATIONPATH'].' '.$vis_language['TXTSETTO'].' '.$audit_log[$i]['description'];}
							}							
							break;
                            
                            case '119':
							if($audit_log[$i]['new_info']=="update")
							{$audit_log[$i]['audit_log_operation']=$vis_language['TXTITILLASTAUDITDATE'].' '.$vis_language['TXTUPDATEDTO'].' '.format_datetime($audit_log[$i]['description']);}
						    else{
					     	$audit_log[$i]['audit_log_operation']=$vis_language['TXTITILLASTAUDITDATE'].' '.$vis_language['TXTSETTO'].' '.format_datetime($audit_log[$i]['description']);}
                            break;
							
							case '120':
							if($audit_log[$i]['new_info']=="update")
							{$audit_log[$i]['audit_log_operation']=$vis_language['TXTITILSALVAGE'].' '.$vis_language['TXTUPDATEDTO'].' '.$audit_log[$i]['description'];}
						    else{
							$audit_log[$i]['audit_log_operation']=$vis_language['TXTITILSALVAGE'].' '.$vis_language['TXTSETTO'].' '.$audit_log[$i]['description'];}
							break;
							
							case '121':
							include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
                            $setting=new class_setting($database);
							$filter='finance_id='.$audit_log[$i]['description'];
							$depreciation_details=$setting->get_finance_management_list($filter,$data='',VIS_STAFF_ID, VIS_LOCATION_AREA,$limit='');
							$dtype=$depreciation_details[0]['name'];
							if($audit_log[$i]['new_info']=="update")
							{
							$audit_log[$i]['audit_log_operation']=$vis_language['TXTDEPRECIATIONTYPE'].' '.$vis_language['TXTUPDATEDTO'].' '.$dtype;}
							else{
							$audit_log[$i]['audit_log_operation']=$vis_language['TXTDEPRECIATIONTYPE'].' '.$vis_language['TXTSETTO'].' '.$dtype; }
							break;
							
                         
						}
					}
					 $database->database_disconnect();
					 include_once(VIS_PATH_TEMPLATE.'cmdb_audit_log.php');
                     return true;
				}					
		
	}
	function cmdb_assets_edit($operation){
		global $vis_language;
        $spliter=(strstr($operation['vis_action'], '/'))?'/':',';
		$action=explode($spliter, $operation['vis_action']);
		if(isset($operation['vis_assets_id']) && $operation['vis_assets_id']!='' && is_numeric($operation['vis_assets_id'])) {
			
            $database=new class_database();
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'cmdb.php');
			$cmdb_object=new class_cmdb($database);
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
			$setting_object=new class_setting($database);
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
			$sub_object=new class_subsetting($database);
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
			$object_ticket=new class_ticket($database);
			
            $filter=VIS_TABLE_PREFIX.'itil_cmdb_assets.assets_id='.$operation['vis_assets_id'].' ';
			$assets_details=$cmdb_object->get_assets($filter, 1, 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
			$assets_details=$assets_details[0];
			if (defined('VIS_HTML_EDITOR') && VIS_HTML_EDITOR != 1) {  	
				$assets_details['description'] = get_plain_text($assets_details['description']);	
		    }
			if($assets_details['attachment_id']!=''){
				$files= explode(',', $assets_details['attachment_id']);
				for($i=0;$i<count($files)-1;$i++){
					$assets_details['files'][]=$cmdb_object->get_uploaded_file('attachment_id='.$files[$i], '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
				}
			}
			if($assets_details['ci_property_type']==0 && $assets_details['ci_property_type']==''){
				$operation['vis_product_id']='';
				$operation['vis_vendor_id']='';
				$operation['vis_warranty_year']='';
				$operation['vis_warranty_month']='';
				$operation['vis_installation_date']='';
				$operation['vis_expiry_date']='';
				$operation['vis_assets_state']='';
				$operation['vis_asset_tag']='';
				$operation['vis_installation_path']='';
				$operation['vis_licence_key']='';
				$operation['vis_last_audit_date']='';
				$operation['vis_salvage']='';
				$operation['vis_depreciation_type']='';				
			}
			
			$filter = VIS_TABLE_PREFIX."itil_impact.department_access = 0 OR FIND_IN_SET(".$assets_details['department_access'].", ".VIS_TABLE_PREFIX."itil_impact.department_access)>0";
			list($impact_info, $impact_details)=$setting_object->get_impact($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
			
			$filter = "and is_enabled=1 and (".VIS_TABLE_PREFIX."itil_configuration_item.department_access = 0 OR FIND_IN_SET(".$assets_details['department_access'].", ".VIS_TABLE_PREFIX."itil_configuration_item.department_access)>0)";
			$citype_details=$setting_object->get_configuration_item($filter,0, -1, '', VIS_STAFF_ID);
			
			$filter = " and (".VIS_TABLE_PREFIX."itil_location.department_access = 0 OR FIND_IN_SET(".$assets_details['department_access'].", ".VIS_TABLE_PREFIX."itil_location.department_access)>0)";
			$location_details=$setting_object->get_locations($filter,0, -1, '', VIS_STAFF_ID);
		
			//list($impact_info, $impact_details)=$setting_object->get_impact('', '', '', 'display_order ASC', VIS_STAFF_ID, VIS_LOCATION_AREA);
			//$citype_details=$setting_object->get_configuration_item_category('','is_enabled=1');
			//$location_details=$setting_object->get_location_category('','is_enabled=1');
			//list($department_info,$department_details)=$sub_object->get_department(VIS_TABLE_PREFIX.'department.is_enabled=1','',0,0,VIS_STAFF_ID, VIS_LOCATION_AREA);
			$assets_department=explode(',', $assets_details['department_access']);
			$filter=VIS_TABLE_PREFIX.'department.is_enabled=1 and '.VIS_TABLE_PREFIX.'domain.is_enabled=1';
			$department_details=$object_ticket->get_department($filter, VIS_STAFF_ID, VIS_LOCATION_AREA, VIS_TABLE_PREFIX.'domain.domain_id');
            $operation['view_title']=$vis_language['TXTASSETS'];
			$operation['vis_config_id']=$operation['ci_type_id']=$assets_details['ci_type_id'];
			$operation['assets_id']=$assets_details['assets_id'];
			$operation['assetflg']='1';
			$operation['propertyflg']='1';
			$operation['vis_module_section']='edit';
			$operation['vis_property_type']=$assets_details['ci_property_type'];
			
			foreach($assets_details as $key=>$val)
			{
			$operation['vis_'.$key]=$val;
			}
			//==================
			if($operation['vis_property_type']==2)
			{
				$operation['vis_section'] = 'software';
				if($operation['vis_vendor_id']!='' && $operation['vis_vendor_id']!=0)
				{
					$filter2 = 'p.vendor_id='.$operation['vis_vendor_id'].'';
					$vendor_details=$setting_object->get_ciproduct_list($filter2,$data='',VIS_STAFF_ID, VIS_LOCATION_AREA,$limit='');
				}
				$filter=VIS_TABLE_PREFIX.'itil_ci_product.ci_type_id='.$operation['vis_config_id'].'    AND '.VIS_TABLE_PREFIX.'itil_ci_product.is_enabled=1 ';
				list($ci_product_info, $product_details)=$setting_object->get_ci_product($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
				//$filter1= VIS_TABLE_PREFIX.'itil_license_type.is_enabled=1';
				$filter1=VIS_TABLE_PREFIX.'itil_license_type.is_enabled=1 and ('.VIS_TABLE_PREFIX.'itil_license_type.department_access=0 or find_in_set('.$assets_details['department_access'].','.VIS_TABLE_PREFIX.'itil_license_type.department_access)) ';
				list($license_type_info, $license_type_details)=$setting_object->get_license_type($filter1, $limit, $page, $sort_by, VIS_STAFF_ID, VIS_LOCATION_AREA);
			}
			elseif($operation['vis_property_type']==1)
			{
				$operation['vis_section'] = 'hardware';
				if($operation['vis_vendor_id']!='' && $operation['vis_vendor_id']!=0)
				{
					$filter2 = VIS_TABLE_PREFIX.'itil_vendor.vendor_id='.$operation['vis_vendor_id'].' and '.'p.product_id='.$operation['vis_product_id'].'    AND '.VIS_TABLE_PREFIX.'itil_ci_product.is_enabled=1 ';
					$vendor_details=$setting_object->get_ciproduct_list($filter2,$data='',VIS_STAFF_ID, VIS_LOCATION_AREA,$limit='');
				}
				$filter=VIS_TABLE_PREFIX.'itil_ci_product.ci_type_id='.$operation['vis_config_id'].' ';
				list($ci_product_info, $product_details)=$setting_object->get_ci_product($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
				$filter4=VIS_TABLE_PREFIX.'itil_finance_management.is_enabled=1';
				$filter1=VIS_TABLE_PREFIX.'itil_asset_state.is_enabled=1  and (department_access=0 or find_in_set('.$assets_details['department_access'].',department_access))';
				$depreciation_details=$setting_object->get_finance_management_list($filter4,$data='',VIS_STAFF_ID, VIS_LOCATION_AREA,$limit='');
				list($asset_state_info, $asset_state_details)=$setting_object->get_asset_state($filter1, $limit='', $page='', $sort_by='', VIS_STAFF_ID, VIS_LOCATION_AREA);
			}
			//===================**
			$customdata=$this->get_custom_fields($operation);
            include(VIS_PATH_TEMPLATE.'cmdb_assets_details.php');
			return true;
        }
        else {
            $this->error=$vis_language['MSGINFOMISS'];
            return false;
        }
	}
	
	function update_ci($operation) {
	    global $vis_language;
	    $operation['view_title']=$vis_language['TXTASSETS'];		
        $data=parse_form_array($operation['vis_action']);
		$name = str_replace(",,",",",$operation['vis_attach_name']);
		$tmp_name=rtrim($name, ",");
		$data['vis_attach_name']=$tmp_name;
		$mystring = $data['vis_name'];
		$findme   = '/';
		if(VIS_LOCATION_AREA!=0){
			$pos = strpos($mystring, $findme);
			if(is_numeric($pos)) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGTILALPHNUM'].'"); </script>';
				return false;
			}elseif(!isset($data['vis_name']) || trim($data['vis_name'])=='') {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFLDNAME'].'"); </script>';
				return false;
			}
			if(((!isset($data['vis_department'])) || $data['vis_department']=='0')) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQUIREDFIELDDEPARTMENT'].'"); </script>';
				return false;
			}
			if(!isset($data['vis_ci_type_id']) || trim($data['vis_ci_type_id'])=='') {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFLDCITYPE'].'"); </script>';
				return false;
			}
			if(isset($data['vis_product_id']) && $data['vis_product_id']==0) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFLDPRODUCT'].'"); </script>';
				return false;
			}
			if(isset($data['vis_assets_state']) && $data['vis_assets_state']==0 && $data['vis_ci_type_id']==2) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFLDASSETSTATE'].'"); </script>';
				return false;
			}
		}
		if(VIS_LOCATION_AREA==0){
			$data = $operation;
			if($data['vis_ci_type_id']==2){
				$data['vis_installation_date'] = $data['vis_acquisition_date'];
				$data['vis_expiry_date'] = $data['vis_warranty_expiry_date'];
				$data['vis_licence_key'] = $data['vis_serial_number'];
				$data['vis_installation_path'] = $data['vis_cost'];
			}
			if($data['vis_ci_type_id']==2){
				$data['vis_assets_state'] = $data['vis_license_type'];
				$data['vis_asset_tag'] = $data['vis_cost'];
				$data['vis_expiry_date'] = $data['vis_license_expiry_date'];
			}
			
		}
		/*if(isset($data['vis_assets_state']) && $data['vis_assets_state']==0 && $data['vis_ci_type_id']==3) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGREQFLDLICENCETYPE'].'"); </script>';
            return false;
        }*/
        if(defined('VIS_HTML_EDITOR') && VIS_HTML_EDITOR==0) 
        $data['vis_description'] = str_replace(array("\r\n","\r","\n"),"<br>",$data['vis_description']);
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
		$sub_object=new class_subsetting($database);
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'cmdb.php');
		$cmdb_object=new class_cmdb($database);
		$data['vis_ci_action'] = 'update';
		$check_custom=$cmdb_object->check_cmdbcustom_data($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if(!$check_custom[0])
		{
			echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGINFOMISS'].'('.$check_custom[1].')"); </script>';
				return false;
		}
		
		$ret=$cmdb_object->update_ci_data($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if(VIS_LOCATION_AREA==0){
			if(!$ret) {
				echo 'error in operation';
				return false;
			}
			else {
				$activity_log=$sub_object->add_staff_activity_log("Modified ".$data['vis_name']." CI ", VIS_STAFF_ID,'', VIS_LOCATION_AREA);
				echo 'Success';
			}			
		}else{
			if(!$ret) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGERROPRT'].'"); </script>';
				return false;
			}
			else {
				$activity_log=$sub_object->add_staff_activity_log("Modified ".$data['vis_name']." CI ", VIS_STAFF_ID,'', VIS_LOCATION_AREA);
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", " '.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_module","'.$vis_language['TXTASSETS'].'",{"vis_module":"cmdb", "vis_operation":"assets"}); </script>';
			}
		}
        $database->database_disconnect();
        return true;
    }
	
	function get_assets_delete($operation) {
        global $vis_language;
        $message_info['vis_form_title']=$vis_language['TXTDELCI'];
		$message_info['vis_message']=$vis_language['MSGSURE'];
        $message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'".$operation['vis_module']."', 'vis_operation':'delete_assets', 'vis_assets_id':".$operation['vis_assets_id']."})";
        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
    }

    function delete_assets($operation){
		global $vis_language;
        $flag=true;
        $database=new class_database();
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'cmdb.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'subsetting.php');
        $cmdb_object=new class_cmdb($database);
        $setting_object=new class_setting($database);
		$object=new class_subsetting($database);

		$assets=$cmdb_object->get_assets('assets_id='.$operation['vis_assets_id'], '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
			
		if($assets!=-1) { 
            $ret = $cmdb_object->delete_assets($operation['vis_assets_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);	 
		 	$ret=$cmdb_object->delete_attach1_relation($operation['vis_assets_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
		}
        if(!isset($ret)) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$setting_object->add_staff_activity_log("Removed  ".$assets[0]['name']." Assets CI", VIS_STAFF_ID,'', VIS_LOCATION_AREA);
			echo '<script>$("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'"); $("#vis_workpanel_div").visExecution("load_area",{"vis_module":"'.$operation['vis_module'].'", "vis_operation":"assets"}); </script>';
		}
        $database->database_disconnect();
        return true;
	}
	//***************************END**********************************************
	function get_relationships_list($operation){
		global $vis_language;
        //include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
        $database=new class_database();
        //$staff=new class_staff($database);
        //$object=new class_ticket($database);
        //list($view_info, $view_details)=$staff->get_ticket_view(VIS_STAFF_ID, VIS_LOCATION_AREA);
        //$view_info['page_count'];
		//$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
        //$limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'cmdb.php');
        $cmdb=new class_cmdb($database);
		$relation_info = array();
		$filter=VIS_TABLE_PREFIX.'itil_attach_relationships.assets_id='.$operation['vis_assets_id'].' or '.VIS_TABLE_PREFIX.'itil_attach_relationships.ci_id='.$operation['vis_assets_id'];
		$attach_relation_details = $cmdb->get_cmdb_relations_list($filter,$limit='',VIS_STAFF_ID, VIS_LOCATION_AREA);
		//$relation_details = $cmdb->get_cmdb_relations_list($filter,'',VIS_STAFF_ID, VIS_LOCATION_AREA);
		//$view_info['page_count']=($relation_details==-1)?0:ceil(count($relation_details)/$view_info['page_count']);
        //$relation_info['total_count']=(!$relation_details || $relation_details==-1)?0:count($relation_details);
		//$relation_info['page']=$page;
        //$database->database_disconnect();
      	include(VIS_PATH_TEMPLATE.'cmdb_relationship.php');
	}
	function attach_relationships($operation){
		global $vis_language;
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'cmdb.php');
		$database=new class_database();
        $cmdb=new class_cmdb($database);
		$relationship_details = $cmdb->get_cmdb_relationships_list($filter,'',VIS_STAFF_ID, VIS_LOCATION_AREA);
      	include(VIS_PATH_TEMPLATE.'attach_cmdb_relationship.php');
	}
	function get_cmdb_relation_ci($operation) {
        global $vis_language;
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
	    $database=new class_database();
        $object=new class_setting($database); 
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'cmdb.php');
        $cmdb_object=new class_cmdb($database);
		$filter=VIS_TABLE_PREFIX.'itil_cmdb_assets.assets_id='.$operation['vis_assets_id'].' ';
		$assets_details=$cmdb_object->get_assets($filter, 1, 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$assets_details=$assets_details[0];
		
		$filter=VIS_TABLE_PREFIX.'itil_attach_relationships.assets_id='.$operation['vis_assets_id'].' or '.VIS_TABLE_PREFIX.'itil_attach_relationships.ci_id='.$operation['vis_assets_id'];
		$attach_relation_details = $cmdb_object->get_cmdb_relations_list($filter,'',VIS_STAFF_ID, VIS_LOCATION_AREA);
		
		$attached_id = '';
		if($attach_relation_details!=-1){
			for($i=0;$i<count($attach_relation_details);$i++){
				if($attach_relation_details[$i]['inverse_assets_id']==$operation['vis_assets_id'])
				$attached_id .= $attach_relation_details[$i]['rel_assets_id'].",";
				if($attach_relation_details[$i]['rel_assets_id']==$operation['vis_assets_id'])
				$attached_id .= $attach_relation_details[$i]['inverse_assets_id'].",";
			}
		}
		
		$confi_item_details=$object->get_configuration_item_category('','is_enabled=1');
		$database->database_disconnect();
        include(VIS_PATH_TEMPLATE.'relation_cmdb_ci.php');
        return true;
    }
	function attached_cmdb_relationships($operation) {
      	global $vis_language;
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
        $database=new class_database();
        $staff=new class_staff($database);
        list($view_info, $view_details)=$staff->get_ticket_view(VIS_STAFF_ID, VIS_LOCATION_AREA);
        $view_info['page_count'];
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
        $limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'cmdb.php');
        $setting=new class_cmdb($database);
		$relation_info = array();
		$filter='attach_type='.$operation['vis_attach_type'];
		$attach_relation_details = $setting->get_cmdb_relations_list($filter,$limit,VIS_STAFF_ID, VIS_LOCATION_AREA);
		$relation_details = $setting->get_cmdb_relations_list($filter,'',VIS_STAFF_ID, VIS_LOCATION_AREA);
		$view_info['page_count']=($relation_details==-1)?0:ceil(count($relation_details)/$view_info['page_count']);
        $relation_info['total_count']=(!$relation_details || $relation_details==-1)?0:count($relation_details);
		$relation_info['page']=$page;
        $database->database_disconnect();
      	include(VIS_PATH_TEMPLATE.'cmdb_relationship.php');
	}
	function attach_new_relationships($operation){
		global $vis_language;
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'cmdb.php');
		$database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $setting_object=new class_setting($database);
        $cmdb=new class_cmdb($database);
		$data=parse_form_array($operation['vis_action']);
		if(!isset($data['total_itemrecord'])) {
            return false;
        }
		$ret = $cmdb->add_cmdb_relationships($data, VIS_STAFF_ID, VIS_LOCATION_AREA);
		if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$setting_object->add_staff_activity_log("New relashionship attached", VIS_STAFF_ID,6, VIS_LOCATION_AREA);
			echo '<script>$("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");';
			echo "$('#vis_details_list').visExecution('load_operations',{'vis_module':'cmdb', 'vis_operation':'get_relationships_list',  'vis_assets_id':'".$data['vis_assets_id']."' });set_active_tab('relationships');$('.modal').modal('toggle');</script>";
		}
    }
	function get_cmdb_relationship_delete($operation) {
        global $vis_language;
        $message_info['vis_form_title']=$vis_language['TXTITILDELRELATIONSHIP'];
		$message_info['vis_message']=$vis_language['MSGSURE'];
        $message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'cmdb', 'vis_operation':'delete_cmdb_relationship', 'vis_relation_id':".$operation['vis_relation_id'].", 'vis_assets_id':".$operation['vis_assets_id'].", 'vis_attach_id':".$operation['vis_attach_id'].", 'vis_relation_name':'".$operation['vis_relation_name']."'})";
        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
    }
	function delete_cmdb_relationship($operation){
		global $vis_language;
        $database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $setting_object=new class_setting($database);
        include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'cmdb.php');
        $cmdb_object=new class_cmdb($database);
		$assets=$cmdb_object->get_assets('assets_id='.$operation['vis_attach_id'], '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
        $ret = $cmdb_object->delete_cmdb_relationship($operation['vis_relation_id'], VIS_STAFF_ID, VIS_LOCATION_AREA);
        if(!$ret) {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
        else {
			$activity_log=$setting_object->add_staff_activity_log("Removed  ".$assets[0]['name']." relationship", VIS_STAFF_ID,6, VIS_LOCATION_AREA);
			echo '<script>$("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");';
			echo "$('#vis_details_list').visExecution('load_operations',{'vis_module':'cmdb', 'vis_operation':'get_relationships_list',  'vis_assets_id':'".$operation['vis_assets_id']."' });</script>";
		}
        $database->database_disconnect();
        return true;
	}
	function get_attach_changes_list($operation) {
        global $vis_language;
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'cmdb.php');
	    include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
	    $database=new class_database();
        $cmdb=new class_cmdb($database);
		$staff=new class_staff($database);
		list($view_info, $view_details)=$staff->get_ticket_view(VIS_STAFF_ID, VIS_LOCATION_AREA);
        $view_info['page_count'];
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
        $limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$operation['section']='changes';
		$attach_info = array();
	    $filter3=VIS_TABLE_PREFIX.'itil_relation.child_id='.$operation['vis_assets_id'].' and attach_type=9';
 	    $attach_details = $cmdb->get_attach_assets_change_list($filter3,$limit,VIS_STAFF_ID, VIS_LOCATION_AREA);
		$attach_details_list = $cmdb->get_attach_assets_change_list($filter3,'',VIS_STAFF_ID, VIS_LOCATION_AREA);
		$view_info['page_count']=($attach_details_list==-1)?0:ceil(count($attach_details_list)/$view_info['page_count']);
        $attach_info['total_count']=(!$attach_details_list || $attach_details_list==-1)?0:count($attach_details_list);
		$attach_info['page']=$page;
		$database->database_disconnect();
        include(VIS_PATH_TEMPLATE.'assets_attachment_list.php');
        return true;
    }
	function get_attach_problems_list($operation) {
        global $vis_language;
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'cmdb.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
        $database=new class_database();
        $staff=new class_staff($database);
        list($view_info, $view_details)=$staff->get_ticket_view(VIS_STAFF_ID, VIS_LOCATION_AREA);
        $view_info['page_count'];
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
        $limit=($page*$view_info['page_count']).','.$view_info['page_count'];
	    $cmdb=new class_cmdb($database);
		$operation['section']='problems';
		$attach_info = array();
	    $filter3=VIS_TABLE_PREFIX.'itil_relation.child_id='.$operation['vis_assets_id'].' and attach_type=4';
	    $attach_details = $cmdb->get_attach_assets_problem_list($filter3,$limit,VIS_STAFF_ID, VIS_LOCATION_AREA);
		$attach_details_list = $cmdb->get_attach_assets_problem_list($filter3,'',VIS_STAFF_ID, VIS_LOCATION_AREA);
		//$relation_details = $cmdb->get_cmdb_relations_list($filter,'',VIS_STAFF_ID, VIS_LOCATION_AREA);
		$view_info['page_count']=($attach_details_list==-1)?0:ceil(count($attach_details_list)/$view_info['page_count']);
        $attach_info['total_count']=(!$attach_details_list || $attach_details_list==-1)?0:count($attach_details_list);
		$attach_info['page']=$page;
        $database->database_disconnect();
	    include(VIS_PATH_TEMPLATE.'assets_attachment_list.php');
        return true;
    }
	function get_attach_ticket_ci_list($operation) {
        global $vis_language;
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'cmdb.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
	    $database=new class_database();
        $cmdb=new class_cmdb($database);
		$staff=new class_staff($database);
		list($view_info, $view_details)=$staff->get_ticket_view(VIS_STAFF_ID, VIS_LOCATION_AREA);
        $view_info['page_count'];
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
        $limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$operation['section']='ticket';
		$attach_info = array();
	    $filter3=VIS_TABLE_PREFIX.'itil_relation.child_id='.$operation['vis_assets_id'].' and attach_type=0';
	    $attach_details = $cmdb->get_attach_ticket_ci_list($filter3,$limit,VIS_STAFF_ID, VIS_LOCATION_AREA);
		$attach_details_list = $cmdb->get_attach_ticket_ci_list($filter3,'',VIS_STAFF_ID, VIS_LOCATION_AREA);
		$view_info['page_count']=($attach_details_list==-1)?0:ceil(count($attach_details_list)/$view_info['page_count']);
        $attach_info['total_count']=(!$attach_details_list || $attach_details_list==-1)?0:count($attach_details_list);
		$attach_info['page']=$page;
		$database->database_disconnect();
        include(VIS_PATH_TEMPLATE.'assets_attachment_list.php');
        return true;
    }
	function cmdb_assets_activity($operation) {
        global $vis_language;
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
		$database=new class_database();
		$staff_object=new class_staff($database);			
	    $setting=new class_setting($database);
		$operation['section']='problems';
	    $filter='module_id=6';
	    list($activitylog_info, $recentActivities) = $setting->get_activity_log($filter, $limit='', $page='', $sort_by='', $userid='', $user='');
		//$database->database_disconnect();
        include(VIS_PATH_TEMPLATE.'relationship_activity.php');
        return true;
    }
	function get_attach_contract_ci_list($operation) {
        global $vis_language;
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'cmdb.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
	    $database=new class_database();
        $cmdb=new class_cmdb($database);
		$staff=new class_staff($database);
		list($view_info, $view_details)=$staff->get_ticket_view(VIS_STAFF_ID, VIS_LOCATION_AREA);
        $view_info['page_count'];
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
        $limit=($page*$view_info['page_count']).','.$view_info['page_count'];
		$operation['section']='contract';
		$attach_info = array();
	    $filter3=VIS_TABLE_PREFIX.'itil_relation.child_id='.$operation['vis_assets_id'].' and attach_type=13';
	    $attach_details = $cmdb->get_attach_contract_ci_list($filter3,$limit,VIS_STAFF_ID, VIS_LOCATION_AREA);
		$attach_details_list = $cmdb->get_attach_contract_ci_list($filter3,'',VIS_STAFF_ID, VIS_LOCATION_AREA);
		$view_info['page_count']=($attach_details_list==-1)?0:ceil(count($attach_details_list)/$view_info['page_count']);
        $attach_info['total_count']=(!$attach_details_list || $attach_details_list==-1)?0:count($attach_details_list);
		$attach_info['page']=$page;
		$database->database_disconnect();
        include(VIS_PATH_TEMPLATE.'assets_attachment_list.php');
        return true;
    }
	
	function update_properties($operation) {
        global $vis_language;
        $list_chk=array();

		$options=parse_form_array($operation['vis_action']);
		$property=$options['action'];
		$operation['vis_action']=$property;
		foreach($options as $data=>$value) if(preg_match('/vis_global_mass_chk_[0-9]/', $data)) $list_chk[]=$value;
          
        if(empty($list_chk)){
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); </script>';
            return false;
        }
		
        if($property=='delete'){
            $database=new class_database();
            global $operation_hnd;
            include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'cmdb.php');
            $cmdb=new class_cmdb($database);
            $ret=$cmdb->set_assets_property($property, $operation, $list_chk, VIS_STAFF_ID, VIS_LOCATION_AREA);
            for($i=0;$i<count($list_chk);$i++) {
                $operation['assets_id']=$list_chk[$i];
            }
            $database->database_disconnect();
           
			if(!$ret) {
				echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'");$("[id^=\'vis_global_mass_chk_\']").attr("checked",false); </script>';
				return false;
			} else 
				echo "<script>$('#vis_workpanel_div').visExecution('load_area', {'vis_module':'cmdb', 'vis_operation':'assets'});</script>";
            return $ret;
        }
        else {
            echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGINFOMISS'].'"); </script>';
            return false;
        }
    }	
	function vis_ci_subcategories($config_details,$vis_config_id) {
		for($c=0;$c<count($config_details);$c++){
			if($config_details[$c]['item_id']==$vis_config_id) return true;
			if(isset($config_details[$c]['subcat']) && $config_details[$c]['subcat']!=NULL) { 
				$config_item_ckeck=$this->vis_ci_subcategories($config_details[$c]['subcat'],$vis_config_id);
				if(isset($config_item_ckeck) && $config_item_ckeck==1) return true; 
			}
		}
		return false;
	}
	function get_assets_properties($operation){
		global $vis_language;
        $database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $setting=new class_setting($database);
		if(strpos($operation['vis_departmentid'],':'))
		{
			$deptdomain=explode(':',$operation['vis_departmentid']);
			$operation['vis_departmentid']=$deptdomain[1];
		}
		if($operation['vis_config_id']!=3){
			$config_details=$setting->get_configuration_item($filter2='', 3, -1, $sort_by='', VIS_LOCATION_AREA);
			//print_r($config_details);
			$config_item_ckeck=$this->vis_ci_subcategories($config_details,$operation['vis_config_id']);
		}elseif($operation['vis_config_id']==3){
			$config_item_ckeck=true;	
		}
		if(isset($config_item_ckeck) && $config_item_ckeck==1){
			$operation['vis_section'] = 'software';
			$filter=VIS_TABLE_PREFIX.'itil_ci_product.ci_type_id='.$operation['vis_config_id'].'   AND '.VIS_TABLE_PREFIX.'itil_ci_product.is_enabled=1 and ('.VIS_TABLE_PREFIX.'itil_ci_product.department_access=0 or find_in_set('.$operation['vis_departmentid'].','.VIS_TABLE_PREFIX.'itil_ci_product.department_access))';
			list($ci_product_info, $product_details)=$setting->get_ci_product($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
			$filter5.=VIS_TABLE_PREFIX.'itil_license_type.is_enabled=1 and ('.VIS_TABLE_PREFIX.'itil_license_type.department_access=0 or find_in_set('.$operation['vis_departmentid'].','.VIS_TABLE_PREFIX.'itil_license_type.department_access)) ';
			list($license_type_info, $license_type_details)=$setting->get_license_type($filter5, $limit='', $page='', $sort_by='', VIS_STAFF_ID, VIS_LOCATION_AREA);
			$database->database_disconnect();
			include(VIS_PATH_TEMPLATE.'assets_properties.php');
		}
		if(!$config_item_ckeck){
			if($operation['vis_config_id']!=2){
				$config_details1=$setting->get_configuration_item($filter3='', 2, -1, $sort_by='', VIS_LOCATION_AREA);
				//print_r($config_details);
				$config_item_ckeck1=$this->vis_ci_subcategories($config_details1,$operation['vis_config_id']);
			}else{
				$config_item_ckeck1=true;	
			}
			if(isset($config_item_ckeck1) && $config_item_ckeck1==1){
				$operation['vis_section'] = 'hardware';
				$filter=VIS_TABLE_PREFIX.'itil_ci_product.ci_type_id='.$operation['vis_config_id'].'   AND '.VIS_TABLE_PREFIX.'itil_ci_product.is_enabled=1 and ('.VIS_TABLE_PREFIX.'itil_ci_product.department_access=0 or find_in_set('.$operation['vis_departmentid'].','.VIS_TABLE_PREFIX.'itil_ci_product.department_access))';
				list($ci_product_info, $product_details)=$setting->get_ci_product($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
				$filter4=VIS_TABLE_PREFIX.'itil_finance_management.is_enabled=1';
				$depreciation_details=$setting->get_finance_management_list($filter4,$data='',VIS_STAFF_ID, VIS_LOCATION_AREA,$limit='');
				$filter1=VIS_TABLE_PREFIX.'itil_asset_state.is_enabled=1 and (department_access=0 or find_in_set('.$operation['vis_departmentid'].',department_access))';
				
				list($asset_state_info, $asset_state_details)=$setting->get_asset_state($filter1, $limit='', $page='', $sort_by='', VIS_STAFF_ID, VIS_LOCATION_AREA);
				$database->database_disconnect();
				include(VIS_PATH_TEMPLATE.'assets_properties.php');
			}	
		}
	}
	function get_edit_assets_properties($operation){
	
		global $vis_language;
        $database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $setting=new class_setting($database);
		//print_r($operation);
		if($operation['vis_property_type']==2){
			$operation['vis_section'] = 'software';
			if($operation['vis_vendor_id']!='' && $operation['vis_vendor_id']!=0){
				$filter2 = 'p.vendor_id='.$operation['vis_vendor_id'].'';
				$vendor_details=$setting->get_ciproduct_list($filter2,$data='',VIS_STAFF_ID, VIS_LOCATION_AREA,$limit='');
			}
			$filter=VIS_TABLE_PREFIX.'itil_ci_product.ci_type_id='.$operation['vis_config_id'].'    AND '.VIS_TABLE_PREFIX.'itil_ci_product.is_enabled=1 ';
			list($ci_product_info, $product_details)=$setting->get_ci_product($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
			$filter1= VIS_TABLE_PREFIX.'itil_license_type.is_enabled=1';
			list($license_type_info, $license_type_details)=$setting->get_license_type($filter1, $limit, $page, $sort_by, VIS_STAFF_ID, VIS_LOCATION_AREA);
			$database->database_disconnect();
		
				include(VIS_PATH_TEMPLATE.'assets_properties.php');
			
		}elseif($operation['vis_property_type']==1){
			$operation['vis_section'] = 'hardware';
			if($operation['vis_vendor_id']!='' && $operation['vis_vendor_id']!=0){
				$filter2 = VIS_TABLE_PREFIX.'itil_vendor.vendor_id='.$operation['vis_vendor_id'].' and '.'p.product_id='.$operation['vis_product_id'].'    AND '.VIS_TABLE_PREFIX.'itil_ci_product.is_enabled=1 ';
				$vendor_details=$setting->get_ciproduct_list($filter2,$data='',VIS_STAFF_ID, VIS_LOCATION_AREA,$limit='');
			}
			$filter=VIS_TABLE_PREFIX.'itil_ci_product.ci_type_id='.$operation['vis_config_id'].' ';
			list($ci_product_info, $product_details)=$setting->get_ci_product($filter, '', '', '', VIS_STAFF_ID, VIS_LOCATION_AREA);
			$filter4=VIS_TABLE_PREFIX.'itil_finance_management.is_enabled=1';
			$depreciation_details=$setting->get_finance_management_list($filter4,$data='',VIS_STAFF_ID, VIS_LOCATION_AREA,$limit='');
			$filter1=VIS_TABLE_PREFIX.'itil_asset_state.is_enabled=1';
			list($asset_state_info, $asset_state_details)=$setting->get_asset_state($filter1, $limit='', $page='', $sort_by='', VIS_STAFF_ID, VIS_LOCATION_AREA);
			$database->database_disconnect();
			
				include(VIS_PATH_TEMPLATE.'assets_properties.php');
			
				
		}
	}
	function get_product_vendor($operation){
		global $vis_language;
        $database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
		$setting=new class_setting($database);
		$filter = 'p.product_id='.$operation['vis_product_id'].'';
        $vendor_details=$setting->get_ciproduct_list($filter,$data='',VIS_STAFF_ID, VIS_LOCATION_AREA,$limit='');
		//print_r($vendor_details);
		echo '<label class="col-sm-2 control-label">'.$vis_language['TXTVENDOR'].'</label>
			<div class="col-sm-10">
				<select name="vis_vendor_id" id="vis_vendor_id" class="form-control input-sm selectpicker"';
				if(count($vendor_details)>10) echo 'data-live-search="true"';		
			
			echo '><option value="0">'.$vis_language['TXTSELECT'].'</option>';
				if($vendor_details!=-1) 
					for($v=0;$v<count($vendor_details);$v++){
						echo '<option value="'.$vendor_details[$v]['vendor_id'].'">'.$vendor_details[$v]['vendor_name'].'</option>';
					}
			echo '</select>
			</div>';
	}
	function get_depreciation_schedule($operation){
		global $vis_language;
		$data=parse_form_array($operation['vis_action']);
		$operation = array_merge($operation,$data);
		$useful_life = $operation['vis_useful_life'];
		if($operation['vis_depreciation_type']==1){ 
			$aquisition_date = date("m",$operation['vis_aquisition_date']);
			$useful_year = date("Y",$operation['vis_aquisition_date']);
			$available_month=12-$aquisition_date+1;
			$reamaining_year = $operation['vis_useful_life'];
			if($available_month<12){
				 $operation['vis_useful_life']=$operation['vis_useful_life']+1;
				 $last_loop= $operation['vis_useful_life']-1;
				 $last_month = 12-$available_month;
			}
			for($i=0;$i<$operation['vis_useful_life'];$i++) {
			  $reamaining_year=$reamaining_year-1;
				 if($i==0){
					$month_expence = $operation['vis_expence']/12;
					$final_expense=$month_expence*$available_month;
					$book_value = $operation['vis_cost']-$final_expense;
					$depreciation_expense = $final_expense;
					$accumulated_expense = $final_expense; 
				 }elseif(isset($last_month) && isset($last_loop) && $last_loop==$i){
					$month_expence = $operation['vis_expence']/12;
					$final_expense=$month_expence*$last_month;
					$book_value = $book_value-$final_expense;
					$depreciation_expense = $final_expense;
					$accumulated_expense = $final_expense+$accumulated_expense; 
					$last_month=0;
				 }else{
					$accumulated_expense = $accumulated_expense+$operation['vis_expence'];
					$depreciation_expense = $operation['vis_expence'];  
					$book_value = $book_value-$operation['vis_expence'];				
				 }
				  if($book_value>=$operation['vis_salvage']){
					  $depArr[$i]['useful_year']=$useful_year;
					  $depArr[$i]['vis_cost']=$operation['vis_cost'];
					  $depArr[$i]['depreciation_expense']=$depreciation_expense;
					  $depArr[$i]['accumulated_expense']=$accumulated_expense;
					  $depArr[$i]['book_value']=$book_value;
					  $depArr[$i]['reamaining_year']=$reamaining_year;
					  $depArr[$i]['last_month']=$last_month;
					  $useful_year = $useful_year+1;
					  if(isset($depArr[$i]['last_month']))
					  $depArr[$i]['remaining_life'] = ($depArr[$i]['reamaining_year']>0)?$depArr[$i]['reamaining_year'].' Year '.$depArr[$i]['last_month'].' Month':$depArr[$i]['last_month'].' Month';
					  else
					 $depArr[$i]['remaining_life'] = $depArr[$i]['reamaining_year'].' Year ';   
			}
			}
		}
		elseif($operation['vis_depreciation_type']==2){
		$aquisition_date = date("m",$operation['vis_aquisition_date']);
		$useful_year = date("Y",$operation['vis_aquisition_date']);
		$available_month=12-$aquisition_date+1;
		$reamaining_year = $operation['vis_useful_life'];
		if($available_month<12){
			 $vis_useful_life=$operation['vis_useful_life']+1;
			 $last_loop= $operation['vis_useful_life'];
			 $last_month = 12-$available_month;
		}else $vis_useful_life=$operation['vis_useful_life'];
		for($i=0;$i<$vis_useful_life;$i++) {
			  $reamaining_year=$reamaining_year-1;
				if($i==0){
					$percent = (1/$operation['vis_useful_life'])*100;
					$depre_expense = ($operation['vis_cost'])*($percent/100)*($available_month/12);
					$book_value = $operation['vis_cost']-$depre_expense;
					$accumulated_expense = $depre_expense; 
					//$depre_expense = $final_expense;
				 }elseif(isset($last_month) && isset($last_loop) && $last_loop==$i){
					$percent = (1/$operation['vis_useful_life'])*100;
					$depre_expense = ($book_value)*($percent/100)*($last_month/12);
					//($140,000 - $31,500) x 30% x 12/12 
					$accumulated_expense = $depre_expense+$accumulated_expense;
					$book_value = $book_value-$depre_expense;
					$last_month=0;
				 }else{
					$percent = (1/$operation['vis_useful_life'])*100;
					$depre_expense = ($book_value)*($percent/100)*(12/12);
					//($140,000 - $31,500) x 30% x 12/12 
					$accumulated_expense = $depre_expense+$accumulated_expense;
					$book_value = $book_value-$depre_expense;
					//$accumulated_expense = $accumulated_expense+$operation['vis_expence'];  
					//$book_value = $book_value-$operation['vis_expence'];				
				 }
		if($book_value>=$operation['vis_salvage']){
			  $depArr[$i]['useful_year']=$useful_year;
			  $depArr[$i]['vis_cost']=$operation['vis_cost'];
			  $depArr[$i]['depreciation_expense']=round($depre_expense,2);
			  $depArr[$i]['accumulated_expense']=round($accumulated_expense,2);;
			  $depArr[$i]['book_value']=round($book_value,2);
			  $depArr[$i]['reamaining_year']=$reamaining_year;
			  $depArr[$i]['last_month']=$last_month;
			 $useful_year = $useful_year+1;
			  if(isset($depArr[$i]['last_month']))
			  $depArr[$i]['remaining_life'] = ($depArr[$i]['reamaining_year']>0)?$depArr[$i]['reamaining_year'].' Year '.$depArr[$i]['last_month'].' Month':$depArr[$i]['last_month'].' Month';
			  else
			 $depArr[$i]['remaining_life'] = $depArr[$i]['reamaining_year'].' Year ';   
	     }
	    }
	    }elseif($operation['vis_depreciation_type']==3){
		$aquisition_date = date("m",$operation['vis_aquisition_date']);
		$useful_year = date("Y",$operation['vis_aquisition_date']);
		$available_month=12-$aquisition_date+1;
		$reamaining_year = $operation['vis_useful_life'];
		if($available_month<12){
			 $vis_useful_life=($operation['vis_useful_life']+1);
			 $last_loop= $operation['vis_useful_life'];
			 $last_month = 12-$available_month;
		}else $vis_useful_life=$operation['vis_useful_life'];
		for($i=0;$i<$vis_useful_life;$i++) {
		    $reamaining_year=$reamaining_year-1;
		    if($i==0){
				$percent = (1/$operation['vis_useful_life'])*100;
				$depre_expense = ($operation['vis_cost'])*(($percent*2)/100)*($available_month/12);
			 	$book_value = $operation['vis_cost']-$depre_expense;
				$accumulated_expense = $depre_expense; 
				//$depre_expense = $final_expense;
			 }else{
				$percent = (1/$operation['vis_useful_life'])*100;
				$depre_expense = ($book_value)*(($percent*2)/100)*(12/12);
				$accumulated_expense = $depre_expense+$accumulated_expense;
		        $book_value = $book_value-$depre_expense;
			    //$accumulated_expense = $accumulated_expense+$operation['vis_expence'];  
				//$book_value = $book_value-$operation['vis_expence'];				
			 }
			 if($book_value>=$operation['vis_salvage']){
			  $depArr[$i]['useful_year']=$useful_year;
			  $depArr[$i]['vis_cost']=$operation['vis_cost'];
			  $depArr[$i]['depreciation_expense']=round($depre_expense,2);
			  $depArr[$i]['accumulated_expense']=round($accumulated_expense,2);;
			  $depArr[$i]['book_value']=round($book_value,2);
			  $depArr[$i]['reamaining_year']=$reamaining_year;
			  $depArr[$i]['last_month']=$last_month;
				 
				 $useful_year = $useful_year+1;
				 if(isset($depArr[$i]['last_month']))
				 $depArr[$i]['remaining_life'] = ($depArr[$i]['reamaining_year']>0)?$depArr[$i]['reamaining_year'].' Year '.$depArr[$i]['last_month'].' Month':$depArr[$i]['last_month'].' Month';
				 else
				 $depArr[$i]['remaining_life'] = $depArr[$i]['reamaining_year'].' Year ';    
		  }else{
			  $factor_value=$operation['vis_salvage']-$book_value.'<br>';
			  $depre_expense=$depre_expense-$factor_value;
			  $accumulated_expense = $accumulated_expense-$factor_value;
		      $book_value = $book_value+$factor_value;
			  $depArr[$i]['useful_year']=$useful_year;
			  $depArr[$i]['vis_cost']=$operation['vis_cost'];
			  $depArr[$i]['depreciation_expense']=round($depre_expense,2);
			  $depArr[$i]['accumulated_expense']=round($accumulated_expense,2);;
			  $depArr[$i]['book_value']=round($book_value,2);
			  $depArr[$i]['reamaining_year']=$reamaining_year;
			  $depArr[$i]['last_month']=$last_month;
			  if(isset($depArr[$i]['last_month']))
			  $depArr[$i]['remaining_life'] = ($depArr[$i]['reamaining_year']>0)?$depArr[$i]['reamaining_year'].' Year '.$depArr[$i]['last_month'].' Month':$depArr[$i]['last_month'].' Month';
			  else
			 $depArr[$i]['remaining_life'] = $depArr[$i]['reamaining_year'].' Year ';     
				 
		  }
		  }
		  }elseif($operation['vis_depreciation_type']==4){
	$aquisition_date = date("m",$operation['vis_aquisition_date']);
	$useful_year = date("Y",$operation['vis_aquisition_date']);
	$available_month=12-$aquisition_date+1;
	$reamaining_year = $operation['vis_useful_life'];
	if($available_month<12){
		 $vis_useful_life=($operation['vis_useful_life']+1);
		 $last_loop= $operation['vis_useful_life'];
		 $last_month = 12-$available_month;
		 $display_month = $last_month;
	}else $vis_useful_life=$operation['vis_useful_life'];
	for($i=0;$i<$vis_useful_life;$i++) {
		  	 $reamaining_year=$reamaining_year-1;
			 if($i==0){
				$sofyd = $operation['vis_useful_life']*($operation['vis_useful_life']+1)/2;
				$depreciable_base = $operation['vis_cost']-$operation['vis_salvage'];
				$depre_expense=($operation['vis_useful_life']/$sofyd)*($available_month/12)*$depreciable_base;
				$book_value = $operation['vis_cost']-$depre_expense;
				$accumulated_expense = $depre_expense; 
			 }else{
				//$sofyd = $operation['vis_useful_life']*($operation['vis_useful_life']+1)/2;
				//$depreciable_base = $operation['vis_cost']-$operation['vis_salvage'];
				$useful_life_old =$operation['vis_useful_life']+1;
				$depre_expense=(($last_month/12)*($useful_life_old/$sofyd)*$depreciable_base)+((($available_month/12)*($operation['vis_useful_life']/$sofyd))*$depreciable_base);
				$book_value = $book_value-$depre_expense;
				$accumulated_expense = $depre_expense+$accumulated_expense; 
			 }
			 if($book_value>=$operation['vis_salvage']){
			  $depArr[$i]['useful_year']=$useful_year;
			  $depArr[$i]['vis_cost']=$operation['vis_cost'];
			  $depArr[$i]['depreciation_expense']=round($depre_expense,2);
			  $depArr[$i]['accumulated_expense']=round($accumulated_expense,2);;
			  $depArr[$i]['book_value']=round($book_value,2);
			  $depArr[$i]['reamaining_year']=$reamaining_year;
			  $depArr[$i]['last_month']=$last_month;
				 if($reamaining_year==0){ $display_month=0;}
			  $operation['vis_useful_life']=$operation['vis_useful_life']-1;
			  $useful_year = $useful_year+1;
			   if(isset($depArr[$i]['last_month']))
			  $depArr[$i]['remaining_life'] = ($depArr[$i]['reamaining_year']>0)?$depArr[$i]['reamaining_year'].' Year '.$depArr[$i]['last_month'].' Month':$depArr[$i]['last_month'].' Month';
			  else
			 $depArr[$i]['remaining_life'] = $depArr[$i]['reamaining_year'].' Year ';     
		  }
	    }
	    }
	     if(isset($operation['vis_export']) && $operation['vis_export']==true) 
        {
			  //$depArr1[0]=$depArr;
              include_once(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.'export.php');
              $export=new export();
              $j=0;
              foreach($depArr as $k)
              {
                    foreach($k as $key=>$val) 
                    {
                        if($key=='useful_year' ) { $key='Year'; $depArr1[$j][$key]=$val; }
                        elseif($key=='vis_cost') { $key='Cost'; $depArr1[$j][$key]=$val; }
                        elseif($key=='depreciation_expense') { $key='Depreciation expense'; $depArr1[$j][$key]=$val; }
                        elseif($key=='accumulated_expense') { $key='Accumulated depreciation'; $depArr1[$j][$key]=$val; }
                        elseif($key=='book_value') { $key='Book value'; $depArr1[$j][$key]=$val; }
                        elseif($key=='remaining_life') { $key='Remaining life'; $depArr1[$j][$key]=$val; }
                    }
                    $j++;
              }
              return $export->export_depreciation_csv($depArr1, 'Depreciation_list');   
        }
        else
		include(VIS_PATH_TEMPLATE.'depreciation_schedule.php');	
		return true;
	}
	function get_export_assets($operation) {
        global $vis_language;
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
	    $database=new class_database();
        $setting_object=new class_setting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
		$ticket_object=new class_ticket($database);
		$filter1=(VIS_TABLE_PREFIX.'department.is_enabled=1 and '.VIS_TABLE_PREFIX.'domain.is_enabled=1');
        $departments=$ticket_object->get_department($filter1, VIS_STAFF_ID, VIS_LOCATION_AREA, VIS_TABLE_PREFIX.'domain.domain_id');
		$staff_department='';
		foreach($departments as $staff_dept){
			$staff_department.=$staff_dept['department_id'].',';
		}
		$staff_department=substr($staff_department, 0, -1);
		$department_id=0;
		//if(isset($operation['vis_dept_id'])) $department_id=$operation['vis_dept_id'];
		$filter = " and (".VIS_TABLE_PREFIX."itil_configuration_item.department_access = 0 OR ".VIS_TABLE_PREFIX."itil_configuration_item.department_access IN($staff_department))";
		$confi_item_details=$setting_object->get_configuration_item($filter,0, -1, '', VIS_STAFF_ID);
			
		//$confi_item_details=$setting_object->get_configuration_item_category('','is_enabled=1');
		$database->database_disconnect();
        include(VIS_PATH_TEMPLATE.'export_assets.php');
        return true;
    }
	function export_assets($operation){
		global $vis_language;
		    $database=new class_database();
			include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'cmdb.php');
			$cmdb_object=new class_cmdb($database);
		    $filter=VIS_TABLE_PREFIX.'itil_cmdb_assets.ci_type_id='.$operation['vis_ci_type'];
			list($result,$assets_details)=$cmdb_object->get_assets_export($filter, VIS_STAFF_ID, VIS_LOCATION_AREA,$operation['vis_ci_type']);
			if($assets_details!=-1){
			
			$custom_fields_data=array();
			
			list($citype_details,$custom_fields_details)=$cmdb_object->get_customfield($operation['vis_ci_type'], VIS_STAFF_ID, VIS_LOCATION_AREA);
			
		if($custom_fields_details != -1 && count($custom_fields_details)>0){
			$cc_count=0;
	
			for($j=0; $j<count($custom_fields_details); $j++){
			
				$val='';
				$fieldnm=$custom_fields_details[$j]['field_name'];
				for($i=0; $i<count($assets_details); $i++){
				
				
					
					if($custom_fields_details[$j]['field_type']<4 || $custom_fields_details[$j]['field_type']==8){

					$custom_data = $cmdb_object->get_customfield_data($custom_fields_details[$j]['customfield_id'],$assets_details[$i]['assets_id']);
					if($custom_data != -1)  $val = $custom_data['content'];
					else $val = $custom_fields_details[$j]['default_value'];
						if($custom_fields_details[$j]['field_type']==8)
						{
							if($custom_data != -1)  $val = $custom_data['content'];
							else $val = $custom_fields_details[$j]['default_value'];
							$val=date('m-d-Y H:i:s',strtotime($val));
						}
					}
					else
					{
					
					$flag = array();     
					$filter='field_group='.$custom_fields_details[$j]['field_group'].' ';
					$sub_customfields_details=$cmdb_object->get_subcustomfield($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
					
					if($sub_customfields_details != -1){
										
							for($cnt=0;$cnt< count($sub_customfields_details);$cnt++)
							{
								  $custom_data = $cmdb_object->get_customfield_data($sub_customfields_details[$cnt]['customfield_id'],$assets_details[$i]['assets_id']);  
								  if($custom_data != -1)  
								  {
											 $flag[$cnt] =  1;
								  }
							}
							$vls=array();
							if($custom_fields_details[$j]['field_type']==4 || $custom_fields_details[$j]['field_type']==7){
							for($k=0;$k< count($sub_customfields_details);$k++){
								$custom_data = $cmdb_object->get_customfield_data($sub_customfields_details[$k]['customfield_id'],$assets_details[$i]['assets_id']);   
								if(($custom_data['content'] === $sub_customfields_details[$k]['default_value'])) 
								$vls[]=$sub_customfields_details[$k]['default_value'];
								else if(count($flag) <= 0 &&  $sub_customfields_details[$k]['is_selected'] == 1) 
								$vls[]=$sub_customfields_details[$k]['default_value'];
							}
							if(count($vls)>0)
							$val=implode('#',$vls);
							else
							$val='';
						}
						if($custom_fields_details[$j]['field_type']==5 || $custom_fields_details[$j]['field_type']==6 ){
						
						$val='';
						for($k=0;$k<count($sub_customfields_details);$k++) {
						
								 $custom_data = $cmdb_object->get_customfield_data($sub_customfields_details[$k]['customfield_id'],$assets_details[$i]['assets_id']);
								
								
								if(($custom_data['content']==$sub_customfields_details[$k]['default_value']) && $val=='') 
								{
									$val=$custom_data['content'];
								}
							}
							
							if ($sub_customfields_details[$k-1]['is_selected'] == 1 && $val=='')
								{
									$val=$sub_customfields_details[$k-1]['default_value'];
								}
						}
						
					}
					
				}
					
						$assets_details[$i][$fieldnm]=$val;
						
				
				}
				}
			}
			}
					//========================
			
		
				include_once(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.'export.php');
                $export=new export(); 
				
				return $export->assets_export_csv($assets_details,'assets'.strtotime(date('M-jS Y G:i')),$result); 
			
		$database->database_disconnect();
		
	}
	function get_assets($operation){
		 $database=new class_database();
		 include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'cmdb.php');
		 $cmdb_object=new class_cmdb($database);
		 $filter=VIS_TABLE_PREFIX.'itil_cmdb_assets.ci_type_id='.$operation['vis_assets_id'];
		 $assets_details=$cmdb_object->get_assets($filter, 1, 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		 if($assets_details==-1){
			 echo 'false';
		 }
		 $database->database_disconnect();
	}
	function get_import_assets($operation) {
        global $vis_language;
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
	    $database=new class_database();
        $setting_object=new class_setting($database);
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
		$ticket_object=new class_ticket($database);
		$filter1=(VIS_TABLE_PREFIX.'department.is_enabled=1 and '.VIS_TABLE_PREFIX.'domain.is_enabled=1');
        $departments=$ticket_object->get_department($filter1, VIS_STAFF_ID, VIS_LOCATION_AREA, VIS_TABLE_PREFIX.'domain.domain_id');
		$staff_department='';
		foreach($departments as $staff_dept){
			$staff_department.=$staff_dept['department_id'].',';
		}
		$staff_department=substr($staff_department, 0, -1);
		$department_id=0;
		//if(isset($operation['vis_dept_id'])) $department_id=$operation['vis_dept_id'];
		$filter = " and (".VIS_TABLE_PREFIX."itil_configuration_item.department_access = 0 OR ".VIS_TABLE_PREFIX."itil_configuration_item.department_access IN($staff_department))";
		$confi_item_details=$setting_object->get_configuration_item($filter,0, -1, '', VIS_STAFF_ID);
			
		//$confi_item_details=$setting_object->get_configuration_item_category('','is_enabled=1');
		$database->database_disconnect();
        include(VIS_PATH_TEMPLATE.'import_assets.php');
        return true;
    }
	function import_assets($operation){
		 global $vis_language;
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'cmdb.php');
	    $database=new class_database();
        $cmdb_object=new class_cmdb($database);
		$file = $_FILES['files']['tmp_name'];
		$handle = fopen($file,"r");
		$data = fgetcsv($handle,1000,";");
		$arr_heading = explode(',',$data[0]);
		do{
			$data['vis_ci_type']=$operation['vis_ci_type'];
			$data['vis_department']=$operation['vis_department'];
			if(isset($data[1])){
				$ret=$cmdb_object->set_import_assets_value($data,VIS_STAFF_ID, VIS_LOCATION_AREA);
			}
		}while ($data = fgetcsv($handle,1000,",","'"));
		header('location:#/cmdb/assets/'.$vis_language['TXTASSETS'].'/msg');		
	}
	function get_license_type_list($operation)
	{
		global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.'ticket.php');
		$ticket_module=new ticket($database);
		$vis_department_id= $operation['department_id'];
		$filter_condtn = '(department_access=0 or  find_in_set('.$vis_department_id.',department_access))';
		$license_type_details=$ticket_module->get_properties('get_licensetype', '', $filter_condtn);	
		$database->database_disconnect();
		if($license_type_details!='')
        echo get_xml($license_type_details, 'licensetype');
        else echo $vis_language['MSGDATANOTFND'];
        return true;
	}
	function get_contract_type_list($operation)
	{
		global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.'ticket.php');
		$ticket_module=new ticket($database);
		$vis_department_id= $operation['department_id'];
		$filter_condtn = '(department_access=0 or find_in_set('.$vis_department_id.',department_access))';
		$contract_type_details=$ticket_module->get_properties('get_contracttype', '', $filter_condtn);	
		$database->database_disconnect();
		if($contract_type_details!='')
        echo get_xml($contract_type_details, 'contracttype');
        else echo $vis_language['MSGDATANOTFND'];
        return true;
	}
	function get_product_list($operation)
	{
		global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.'ticket.php');
		$ticket_module=new ticket($database);
		$vis_department_id= $operation['department_id'];
		//(department_access=0 or find_in_set('.$department.', department_access)
		$filter_condtn = '('.VIS_TABLE_PREFIX.'itil_ci_product.department_access=0 or find_in_set('.$vis_department_id.','.VIS_TABLE_PREFIX.'itil_ci_product.department_access ))';
		$product_details=$ticket_module->get_properties('get_product', '', $filter_condtn);	
		$database->database_disconnect();
		if($product_details!='')
        echo get_xml($product_details, 'product');
        else echo $vis_language['MSGDATANOTFND'];
        return true;
	}
	function get_configuration_item($operation)
	{
		global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.'ticket.php');
		$ticket_module=new ticket($database);
		$vis_department_id= $operation['department_id'];
		$filter_condtn = 'and (department_access=0 or department_access in ('.$vis_department_id.'))';
		$item_details=$ticket_module->get_properties('get_configuration_item', '', $filter_condtn);	
		$database->database_disconnect();
		if($item_details!='')
        echo get_xml($item_details, 'configuration_item');
        else echo $vis_language['MSGDATANOTFND'];
        return true;
	}
	function get_location_list($operation)
	{
		global $vis_language;
		$database=new class_database();
		include_once(VIS_PATH_FUNCTION.VIS_FUNCTION_PREFIX.'ticket.php');
		$ticket_module=new ticket($database);
		$vis_department_id= $operation['department_id'];
		$filter_condtn = 'and (department_access=0 or department_access in ('.$vis_department_id.'))';
		$location_details=$ticket_module->get_properties('get_location', '', $filter_condtn);	
		$database->database_disconnect();
		if($location_details!='')
        echo get_xml($location_details, 'location');
        else echo $vis_language['MSGDATANOTFND'];
        return true;
	}
	function get_attach_release_list($operation) {
        global $vis_language;
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'cmdb.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'staff.php');
        $database=new class_database();
        $staff=new class_staff($database);
        list($view_info, $view_details)=$staff->get_ticket_view(VIS_STAFF_ID, VIS_LOCATION_AREA);
        $view_info['page_count'];
		$page=(isset($operation['vis_page']) && is_numeric($operation['vis_page']))?$operation['vis_page']:0;
        $limit=($page*$view_info['page_count']).','.$view_info['page_count'];
	    $cmdb=new class_cmdb($database);
		$operation['section']='release';
		$attach_info = array();
	    $filter3=VIS_TABLE_PREFIX.'itil_relation.child_id='.$operation['vis_assets_id'].' and attach_type=5';
	    $attach_details = $cmdb->get_cmdb_release_list($filter3,$limit,VIS_STAFF_ID, VIS_LOCATION_AREA);
		$attach_details_list = $cmdb->get_cmdb_release_list($filter3,'',VIS_STAFF_ID, VIS_LOCATION_AREA);
		//$relation_details = $cmdb->get_cmdb_relations_list($filter,'',VIS_STAFF_ID, VIS_LOCATION_AREA);
		$view_info['page_count']=($attach_details_list==-1)?0:ceil(count($attach_details_list)/$view_info['page_count']);
        $attach_info['total_count']=(!$attach_details_list || $attach_details_list==-1)?0:count($attach_details_list);
		$attach_info['page']=$page;
        $database->database_disconnect(); 
	    include(VIS_PATH_TEMPLATE.'assets_attachment_list.php');
        return true;
    }
	function attach_ticket_ci($operation) {
        global $vis_language;
		$data=parse_form_array($operation['vis_action']);
		
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'ticket.php');
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'problem.php');
	    $database=new class_database();
        $ticket_object=new class_ticket($database);
		$problem_object=new class_problem($database);
		$filter=VIS_TABLE_PREFIX.'ticket.ticket_id='.$data['vis_ticket_id'];
		list($ticket_info, $ticket_details)=$ticket_object->get_ticket($filter, 1, 0, '', VIS_STAFF_ID, VIS_LOCATION_AREA);
		$data['vis_attach_type']=0;
		$data['vis_parent_id']=$data['vis_ticket_id'];
		for($i=0;$i<$data['total_itemrecord'];$i++){
			if(isset($data['vis_attach_id_'.$i])){
				$flag=1;
				$data['vis_child_id']=$data['vis_attach_id_'.$i];
				$ret=$problem_object->add_itil_relation($data,VIS_STAFF_ID, VIS_LOCATION_AREA);
				
				$filter = " attach_type=0 AND child_id=".$data['vis_child_id']." AND parent_id=".$data['vis_ticket_id'];
				list($total_ci, $attached_ci)=$problem_object->get_attach_ci($filter, VIS_STAFF_ID, VIS_LOCATION_AREA);
				$ticket_object->add_audit_log($ticket_details[0], 18, $attached_ci[0]['name'],'', VIS_STAFF_ID, VIS_LOCATION_AREA);
			}
		}
		
		$database->database_disconnect();
		if(!$ret) echo '<script> $("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGERROPRT'].'"); $("#vis_service_cost_form").dialog("close"); </script>';
		else{
			echo '<script>$("#vis_global_msg_div").visInterface("load_global_message", "'.$vis_language['MSGSUCCOPRT'].'");';
			echo "$('#vis_details_list_".$data['vis_ticket_id']."').visExecution('load_operations',{'vis_module':'ticket', 'vis_operation':'get_details', 'vis_action':'details', 'vis_ticket_id':".$data['vis_ticket_id'].", 'vis_department_id':".$data['vis_dept_id'].", 'vis_readonly':1});$('.modal').modal('toggle'); </script>";
		}
    }
	function attach_ci_cmdb($operation) {
        global $vis_language;
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
	    $database=new class_database();
        $setting_object=new class_setting($database);

		$department_id=0;
		if(isset($operation['vis_dept_id'])) $department_id=$operation['vis_dept_id'];
		$filter = "and is_enabled=1 and (".VIS_TABLE_PREFIX."itil_configuration_item.department_access = 0 OR FIND_IN_SET($department_id, ".VIS_TABLE_PREFIX."itil_configuration_item.department_access)>0)";
		$confi_item_details=$setting_object->get_configuration_item($filter,0, -1, '', VIS_STAFF_ID);
			
		//$confi_item_details=$setting_object->get_configuration_item_category('','is_enabled=1');
		$database->database_disconnect();
        include(VIS_PATH_TEMPLATE.'attach_config_item.php');
        return true;
    }
	function get_attach_ci_delete($operation) {
        global $vis_language;
        $operation['vis_current_operation']='delete_attach_relation'; 
        $operation['vis_current_module']='subsetting'; 
        $message_info['vis_form_title']=$vis_language['TXTDETACH'];
        $message_info['vis_message']=$vis_language['MSGSURE'];
        $message_info['vis_event']="$('#vis_global_msg_div').visExecution('load_operations', {'vis_module':'".$operation['vis_current_module']."', 'vis_operation':'".$operation['vis_current_operation']."', 'vis_attach_id':".$operation['vis_attach_id'].", 'vis_ticket_id':".$operation['vis_ticket_id'].", 'vis_dept_id':".$operation['vis_dept_id']."})";
        include(VIS_PATH_TEMPLATE.'confirm_delete.php');
        return true;
    }
	// --- new added filter function
	function get_ci_type_option($operation){
		global $vis_language;
        $database=new class_database();
		include_once(VIS_PATH_CLASS.VIS_CLASS_PREFIX.'setting.php');
        $setting=new class_setting($database);
			if($operation['vis_config_id']=='3')
			{  
				$operation['vis_section'] = 'software';
				$filter5.=VIS_TABLE_PREFIX.'get_license_type.is_enabled=1';
				list($license_type_info, $license_type_details)=$setting->get_license_type($filter5='', $limit='', $page='', $sort_by='', VIS_STAFF_ID, VIS_LOCATION_AREA);
				include(VIS_PATH_TEMPLATE.'assets_ci_type_filter.php');
			}
			if($operation['vis_config_id']=='2')
			{	 
				$operation['vis_section'] = 'hardware';
				$filter1.=VIS_TABLE_PREFIX.'itil_asset_state.is_enabled=1';
				list($asset_state_info, $asset_state_details)=$setting->get_asset_state($filter1, $limit='', $page='', $sort_by='', VIS_STAFF_ID, VIS_LOCATION_AREA);
				include(VIS_PATH_TEMPLATE.'assets_ci_type_filter.php');
			}
			$database->database_disconnect();
			
		}
}
?>
